/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.markup.html.list;

import java.util.Collections;
import java.util.Comparator;
import wicket.Component;
import wicket.contrib.markup.html.list.SortableListViewHeaderGroup;
import wicket.markup.ComponentTag;
import wicket.markup.html.border.Border;
import wicket.markup.html.link.Link;

public abstract class SortableListViewHeader
extends Border {
    private boolean ascending = false;
    private final SortableListViewHeaderGroup group;

    public SortableListViewHeader(String componentName, SortableListViewHeaderGroup group) {
        super(componentName);
        this.group = group;
        this.add((Component)new Link("actionLink"){

            public void onClick() {
                SortableListViewHeader.this.linkClicked();
            }
        });
    }

    protected int compareTo(Object o1, Object o2) {
        Comparable obj1 = this.getObjectToCompare(o1);
        Comparable obj2 = this.getObjectToCompare(o2);
        return obj1.compareTo(obj2);
    }

    protected final String getCssClass() {
        return this.group.getCssClass(this.getName(), this.ascending);
    }

    protected Comparable getObjectToCompare(Object object) {
        return (Comparable)object;
    }

    protected void linkClicked() {
        this.ascending = !this.ascending;
        this.group.setSortedColumn(this.getName());
        this.sort();
    }

    protected void onComponentTag(ComponentTag tag) {
        this.group.handleComponentTag(tag, this.getCssClass());
    }

    protected void sort() {
        Collections.sort(this.group.getListViewModelObject(), new Comparator(){

            public int compare(Object o1, Object o2) {
                if (SortableListViewHeader.this.ascending) {
                    return SortableListViewHeader.this.compareTo(o1, o2);
                }
                return SortableListViewHeader.this.compareTo(o2, o1);
            }
        });
    }
}

