/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.markup.html.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import wicket.AttributeModifier;
import wicket.Component;
import wicket.contrib.markup.html.tree.Tree;
import wicket.contrib.markup.html.tree.TreeState;
import wicket.markup.MarkupStream;
import wicket.markup.html.WebMarkupContainer;
import wicket.markup.html.basic.Label;
import wicket.markup.html.image.AbstractImage;
import wicket.markup.html.image.Image;
import wicket.markup.html.image.resource.ImageResource;
import wicket.markup.html.image.resource.StaticImageResource;
import wicket.markup.html.link.Link;
import wicket.markup.html.list.ListItem;
import wicket.markup.html.list.ListView;
import wicket.model.IModel;
import wicket.model.Model;
import wicket.util.resource.IResource;

public abstract class IndentTree
extends Tree
implements TreeModelListener {
    public static final String JUNCTION_IMAGE_NAME = "junctionImage";
    public static final String NODE_IMAGE_NAME = "nodeImage";
    private static final StaticImageResource IMG_BLANK = StaticImageResource.get((Package)(class$wicket$contrib$markup$html$tree$IndentTree == null ? (class$wicket$contrib$markup$html$tree$IndentTree = IndentTree.class$("wicket.contrib.markup.html.tree.IndentTree")) : class$wicket$contrib$markup$html$tree$IndentTree).getPackage(), (String)"blank.gif", null, null);
    private static final StaticImageResource IMG_MINUS = StaticImageResource.get((Package)(class$wicket$contrib$markup$html$tree$IndentTree == null ? (class$wicket$contrib$markup$html$tree$IndentTree = IndentTree.class$("wicket.contrib.markup.html.tree.IndentTree")) : class$wicket$contrib$markup$html$tree$IndentTree).getPackage(), (String)"minus.gif", null, null);
    private static final StaticImageResource IMG_PLUS = StaticImageResource.get((Package)(class$wicket$contrib$markup$html$tree$IndentTree == null ? (class$wicket$contrib$markup$html$tree$IndentTree = IndentTree.class$("wicket.contrib.markup.html.tree.IndentTree")) : class$wicket$contrib$markup$html$tree$IndentTree).getPackage(), (String)"plus.gif", null, null);
    private List treePathList;
    private final TreePathsListView treePathsListView = this.createTreePathsListView();
    static /* synthetic */ Class class$wicket$contrib$markup$html$tree$IndentTree;

    public IndentTree(String componentName, TreeModel model) {
        super(componentName, model);
        this.add((Component)this.treePathsListView);
        model.addTreeModelListener(this);
    }

    protected final TreePathsListView createTreePathsListView() {
        TreeState treeState = this.getTreeState();
        this.treePathList = new ArrayList();
        this.addNodesToTreePathList();
        TreePathsListView treePaths = new TreePathsListView("tree", (IModel)new Model((Serializable)((Object)this.treePathList)));
        return treePaths;
    }

    private final void addNodesToTreePathList() {
        TreeModel model = this.getTreeState().getModel();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)model.getRoot();
        Enumeration<TreeNode> e = rootNode.preorderEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)e.nextElement();
            TreePath path = new TreePath(treeNode.getPath());
            this.treePathList.add(treeNode);
        }
    }

    public final void modelChangedStructure() {
        this.treePathsListView.modelChangedStructure();
    }

    private final Link createJunctionLink(final DefaultMutableTreeNode node) {
        Link junctionLink = new Link("junctionLink"){

            public void onClick() {
                IndentTree.this.junctionLinkClicked(node);
            }
        };
        AbstractImage img = this.getJunctionImage(node);
        junctionLink.add((Component)img);
        return junctionLink;
    }

    protected AbstractImage getJunctionImage(final DefaultMutableTreeNode node) {
        if (!node.isLeaf()) {
            ImageResource imgResource = new ImageResource(){

                protected IResource getResource() {
                    if (IndentTree.this.isExpanded(node)) {
                        return IMG_MINUS.getResource();
                    }
                    return IMG_PLUS.getResource();
                }

                public String getPath() {
                    this.reset();
                    return super.getPath();
                }
            };
            Image img = new Image(JUNCTION_IMAGE_NAME, imgResource);
            return img;
        }
        Image img = new Image(JUNCTION_IMAGE_NAME, (ImageResource)IMG_BLANK);
        return img;
    }

    protected void junctionLinkClicked(DefaultMutableTreeNode node) {
        this.setExpandedState(node);
    }

    private final Link createNodeLink(final DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        Link nodeLink = new Link("nodeLink"){

            public void onClick() {
                IndentTree.this.nodeLinkClicked(node);
            }
        };
        AbstractImage img = this.getNodeImage(node);
        nodeLink.add((Component)img);
        String userObjectAsString = this.getNodeLabel(node);
        nodeLink.add((Component)new Label("label", (Serializable)((Object)userObjectAsString)));
        return nodeLink;
    }

    protected String getNodeLabel(DefaultMutableTreeNode node) {
        return String.valueOf(node.getUserObject());
    }

    protected AbstractImage getNodeImage(DefaultMutableTreeNode node) {
        Image img = new Image(JUNCTION_IMAGE_NAME, (ImageResource)IMG_BLANK);
        return img;
    }

    protected void nodeLinkClicked(DefaultMutableTreeNode node) {
        this.setSelected(node);
    }

    protected boolean equals(TreePath path, TreePath selectedPath) {
        Object pathNode = path.getLastPathComponent();
        Object selectedPathNode = selectedPath.getLastPathComponent();
        boolean equals = pathNode != null && selectedPathNode != null && pathNode.equals(selectedPathNode);
        return equals;
    }

    protected String getCSSClassForSelectedRow() {
        return "treerow-selected";
    }

    protected String getCSSClassForRow() {
        return "treerow";
    }

    public void treeNodesChanged(TreeModelEvent e) {
    }

    public void treeNodesInserted(TreeModelEvent e) {
        TreePath parentPath = e.getTreePath();
        TreeState treeState = this.getTreeState();
        Object[] newNodes = e.getChildren();
        int len = newNodes.length;
        for (int i = 0; i < len; ++i) {
            int insertRow;
            DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)newNodes[i];
            DefaultMutableTreeNode previousNode = newNode.getPreviousSibling();
            if (previousNode == null) {
                previousNode = (DefaultMutableTreeNode)newNode.getParent();
            }
            if (previousNode != null) {
                insertRow = this.treePathList.indexOf(previousNode) + 1;
                if (insertRow == -1) {
                    throw new IllegalStateException("node " + previousNode + " not found in backing list");
                }
            } else {
                insertRow = 0;
            }
            this.treePathList.add(insertRow, newNode);
        }
        this.modelChangedStructure();
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        TreePath parentPath = e.getTreePath();
        TreeState treeState = this.getTreeState();
        Object[] deletedNodes = e.getChildren();
        int len = deletedNodes.length;
        for (int i = 0; i < len; ++i) {
            DefaultMutableTreeNode deletedNode = (DefaultMutableTreeNode)deletedNodes[i];
            this.treePathList.remove(deletedNode);
        }
        this.modelChangedStructure();
    }

    public void treeStructureChanged(TreeModelEvent e) {
        this.treePathList.clear();
        this.addNodesToTreePathList();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class SpacerList
    extends ListView {
        public SpacerList(String componentName, int size) {
            super(componentName, (IModel)null);
            this.setViewSize(size);
        }

        protected void populateItem(ListItem listItem) {
        }
    }

    private final class SelectedPathReplacementModel
    extends Model {
        private final DefaultMutableTreeNode node;

        public SelectedPathReplacementModel(DefaultMutableTreeNode node) {
            this.node = node;
        }

        public Object getObject() {
            boolean equals;
            TreePath path = new TreePath(this.node.getPath());
            TreePath selectedPath = IndentTree.this.getTreeState().getSelectedPath();
            if (selectedPath != null && (equals = IndentTree.this.equals(path, selectedPath))) {
                return IndentTree.this.getCSSClassForSelectedRow();
            }
            return IndentTree.this.getCSSClassForRow();
        }
    }

    private final class TreePathsListView
    extends ListView {
        public TreePathsListView(String name, IModel model) {
            super(name, model);
        }

        protected void onRender() {
            TreeState treeState = IndentTree.this.getTreeState();
            MarkupStream markupStream = this.findMarkupStream();
            int markupStart = markupStream.getCurrentIndex();
            int size = this.getViewSize();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    DefaultMutableTreeNode node;
                    TreePath path;
                    int row;
                    String componentName = Integer.toString(i);
                    ListItem listItem = (ListItem)this.get(componentName);
                    if (listItem == null) {
                        listItem = this.newItem(i);
                        this.populateItem(listItem);
                        this.add((Component)listItem);
                    }
                    if ((row = treeState.getRowForPath(path = new TreePath((node = (DefaultMutableTreeNode)listItem.getModelObject()).getPath()))) != -1) {
                        listItem.setVisible(true);
                    } else {
                        listItem.setVisible(false);
                    }
                    markupStream.setCurrentIndex(markupStart);
                    this.renderItem(listItem, i >= size - 1);
                }
            } else {
                markupStream.skipComponent();
            }
        }

        protected void populateItem(ListItem listItem) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)listItem.getModelObject();
            int level = node.getLevel();
            listItem.add((Component)new SpacerList("spacers", level));
            WebMarkupContainer nodeContainer = new WebMarkupContainer("node");
            Link expandCollapsLink = IndentTree.this.createJunctionLink(node);
            nodeContainer.add((Component)expandCollapsLink);
            Link selectLink = IndentTree.this.createNodeLink(node);
            nodeContainer.add((Component)selectLink);
            listItem.add((Component)nodeContainer);
            listItem.add(new AttributeModifier("class", true, (IModel)new SelectedPathReplacementModel(node)));
        }
    }
}

