/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.markup.html.tree;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import wicket.contrib.markup.html.tree.TreeState;
import wicket.markup.html.panel.Panel;

public abstract class Tree
extends Panel {
    private TreeState treeState;

    public Tree(String componentName, TreeModel model) {
        super(componentName);
        this.treeState = this.newTreeState(model);
    }

    public final void setSelected(DefaultMutableTreeNode node) {
        TreePath selection = new TreePath(node.getPath());
        this.treeState.setSelectedPath(selection);
        this.setExpandedState(selection, true);
    }

    public final void setExpandedState(DefaultMutableTreeNode node) {
        TreePath selection;
        this.setExpandedState(selection, !this.treeState.isExpanded(selection = new TreePath(node.getPath())));
    }

    public final void setExpandedState(TreePath selection, boolean expanded) {
        this.treeState.setExpandedState(selection, expanded);
    }

    public final boolean isExpanded(DefaultMutableTreeNode node) {
        return this.isExpanded(new TreePath(node.getPath()));
    }

    public final boolean isExpanded(TreePath path) {
        return this.treeState.isExpanded(path);
    }

    public final TreeState getTreeState() {
        return this.treeState;
    }

    public final void setTreeState(TreeState treeState) {
        this.treeState = treeState;
    }

    public TreeState newTreeState(TreeModel model) {
        return this.newTreeState(model, true);
    }

    protected final TreeState newTreeState(TreeModel model, boolean rootVisible) {
        TreeState treeStateCache = new TreeState();
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        treeStateCache.setModel(model);
        treeStateCache.setSelectionModel(selectionModel);
        treeStateCache.setRootVisible(rootVisible);
        model.addTreeModelListener(treeStateCache);
        return treeStateCache;
    }

    public final void setRootVisible(boolean rootVisible) {
        this.treeState.setRootVisible(rootVisible);
    }

    public final boolean isRootVisible() {
        return this.treeState.isRootVisible();
    }

    public final String getTreeModelAsDebugString() {
        StringBuffer b = new StringBuffer("-- TREE MODEL --\n");
        TreeState state = this.getTreeState();
        TreeModel treeModel = null;
        if (state != null) {
            treeModel = state.getModel();
        }
        if (treeModel != null) {
            StringBuffer tabs = new StringBuffer();
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
            Enumeration<TreeNode> e = rootNode.preorderEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                tabs.delete(0, tabs.length());
                tabs.append("|");
                for (int i = 0; i < node.getLevel(); ++i) {
                    tabs.append("-");
                }
                b.append(tabs).append(node).append("\n");
            }
        } else {
            b.append("<EMPTY>");
        }
        return b.toString();
    }
}

