/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.markup.html.tree;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public final class TreeState
implements Serializable,
TreeModelListener,
RowMapper {
    private TreePath selectedPath;
    private TreeModel treeModel;
    private TreeSelectionModel treeSelectionModel;
    private boolean rootVisible;
    private TreeStateNode root;
    private int rowCount;
    private Hashtable treePathMapping;
    private SearchInfo info;
    private Stack tempStacks = new Stack();

    public TreeState() {
        this.treePathMapping = new Hashtable();
        this.info = new SearchInfo();
    }

    public void setSelectedPath(TreePath selection) {
        this.setExpandedState(selection, true);
        this.selectedPath = selection;
    }

    public TreePath getSelectedPath() {
        if (this.selectedPath == null && this.isRootVisible()) {
            this.selectedPath = new TreePath(this.getModel().getRoot());
        }
        return this.selectedPath;
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void setSelectionModel(TreeSelectionModel newLSM) {
        if (this.treeSelectionModel != null) {
            this.treeSelectionModel.setRowMapper(null);
        }
        this.treeSelectionModel = newLSM;
        if (this.treeSelectionModel != null) {
            this.treeSelectionModel.setRowMapper(this);
        }
    }

    public TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    public int[] getRowsForPaths(TreePath[] paths) {
        if (paths == null) {
            return null;
        }
        int numPaths = paths.length;
        int[] rows = new int[numPaths];
        for (int counter = 0; counter < numPaths; ++counter) {
            rows[counter] = this.getRowForPath(paths[counter]);
        }
        return rows;
    }

    public void setModel(TreeModel newModel) {
        this.treeModel = newModel;
        this.rebuild(false);
    }

    public void setRootVisible(boolean rootVisible) {
        if (this.isRootVisible() != rootVisible) {
            this.rootVisible = rootVisible;
            if (this.root != null) {
                if (rootVisible) {
                    ++this.rowCount;
                    this.root.adjustRowBy(1);
                } else {
                    --this.rowCount;
                    this.root.adjustRowBy(-1);
                }
                this.visibleNodesChanged();
            }
        }
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public boolean isExpanded(TreePath path) {
        if (path != null) {
            TreeStateNode lastNode = this.getNodeForPath(path, true, false);
            return lastNode != null && lastNode.isExpanded();
        }
        return false;
    }

    public TreePath getPathForRow(int row) {
        if (row >= 0 && row < this.getRowCount() && this.root.getPathForRow(row, this.getRowCount(), this.info)) {
            return this.info.getPath();
        }
        return null;
    }

    public int getRowForPath(TreePath path) {
        if (path == null || this.root == null) {
            return -1;
        }
        TreeStateNode node = this.getNodeForPath(path, true, false);
        if (node != null) {
            return node.getRow();
        }
        TreePath parentPath = path.getParentPath();
        node = this.getNodeForPath(parentPath, true, false);
        if (node != null && node.isExpanded()) {
            return node.getRowToModelIndex(this.treeModel.getIndexOfChild(parentPath.getLastPathComponent(), path.getLastPathComponent()));
        }
        return -1;
    }

    public int getVisibleChildCount(TreePath path) {
        TreeStateNode node = this.getNodeForPath(path, true, false);
        if (node == null) {
            return 0;
        }
        return node.getTotalChildCount();
    }

    public Enumeration getVisiblePathsFrom(TreePath path) {
        if (path == null) {
            return null;
        }
        TreeStateNode node = this.getNodeForPath(path, true, false);
        if (node != null) {
            return new VisibleTreeStateNodeEnumeration(node);
        }
        TreePath parentPath = path.getParentPath();
        node = this.getNodeForPath(parentPath, true, false);
        if (node != null && node.isExpanded()) {
            return new VisibleTreeStateNodeEnumeration(node, this.treeModel.getIndexOfChild(parentPath.getLastPathComponent(), path.getLastPathComponent()));
        }
        return null;
    }

    public void setExpandedState(TreePath path, boolean isExpanded) {
        if (isExpanded) {
            this.ensurePathIsExpanded(path, true);
        } else if (path != null) {
            TreeStateNode childNode;
            TreeStateNode parentNode;
            TreePath parentPath = path.getParentPath();
            if (parentPath != null && (parentNode = this.getNodeForPath(parentPath, false, true)) != null) {
                parentNode.makeVisible();
            }
            if ((childNode = this.getNodeForPath(path, true, false)) != null) {
                childNode.collapse(true);
            }
        }
    }

    public boolean getExpandedState(TreePath path) {
        TreeStateNode node = this.getNodeForPath(path, true, false);
        return node != null ? node.isVisible() && node.isExpanded() : false;
    }

    public void treeNodesChanged(TreeModelEvent e) {
        if (e != null) {
            TreeStateNode changedParent = this.getNodeForPath(e.getTreePath(), false, false);
            int[] changedIndexs = e.getChildIndices();
            if (changedParent != null) {
                int maxCounter;
                if (changedIndexs != null && (maxCounter = changedIndexs.length) > 0) {
                    Object parentValue = changedParent.getUserObject();
                    for (int counter = 0; counter < maxCounter; ++counter) {
                        TreeStateNode child = changedParent.getChildAtModelIndex(changedIndexs[counter]);
                        if (child == null) continue;
                        child.setUserObject(this.treeModel.getChild(parentValue, changedIndexs[counter]));
                    }
                    if (changedParent.isVisible() && changedParent.isExpanded()) {
                        this.visibleNodesChanged();
                    }
                } else if (changedParent == this.root && changedParent.isVisible() && changedParent.isExpanded()) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    public void treeNodesInserted(TreeModelEvent e) {
        if (e != null) {
            int maxCounter;
            TreeStateNode changedParent = this.getNodeForPath(e.getTreePath(), false, false);
            int[] changedIndexs = e.getChildIndices();
            if (changedParent != null && changedIndexs != null && (maxCounter = changedIndexs.length) > 0) {
                boolean isVisible = changedParent.isVisible() && changedParent.isExpanded();
                for (int counter = 0; counter < maxCounter; ++counter) {
                    changedParent.childInsertedAtModelIndex(changedIndexs[counter], isVisible);
                }
                if (isVisible && this.treeSelectionModel != null) {
                    this.treeSelectionModel.resetRowSelection();
                }
                if (changedParent.isVisible()) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        if (e != null) {
            int maxCounter;
            TreePath parentPath = e.getTreePath();
            TreeStateNode changedParentNode = this.getNodeForPath(parentPath, false, false);
            int[] changedIndexs = e.getChildIndices();
            if (changedParentNode != null && changedIndexs != null && (maxCounter = changedIndexs.length) > 0) {
                Object[] children = e.getChildren();
                boolean isVisible = changedParentNode.isVisible() && changedParentNode.isExpanded();
                for (int counter = maxCounter - 1; counter >= 0; --counter) {
                    changedParentNode.removeChildAtModelIndex(changedIndexs[counter], isVisible);
                }
                if (isVisible) {
                    if (this.treeSelectionModel != null) {
                        this.treeSelectionModel.resetRowSelection();
                    }
                    if (this.treeModel.getChildCount(changedParentNode.getUserObject()) == 0 && changedParentNode.isLeaf()) {
                        changedParentNode.collapse(false);
                    }
                    this.visibleNodesChanged();
                } else if (changedParentNode.isVisible()) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    public void treeStructureChanged(TreeModelEvent e) {
        if (e != null) {
            TreePath changedPath = e.getTreePath();
            TreeStateNode changedNode = this.getNodeForPath(changedPath, false, false);
            if (changedNode == this.root || changedNode == null && (changedPath == null && this.treeModel != null && this.treeModel.getRoot() == null || changedPath != null && changedPath.getPathCount() <= 1)) {
                this.rebuild(true);
            } else if (changedNode != null) {
                TreeStateNode parent = (TreeStateNode)changedNode.getParent();
                boolean wasExpanded = changedNode.isExpanded();
                boolean wasVisible = changedNode.isVisible();
                int index = parent.getIndex(changedNode);
                changedNode.collapse(false);
                parent.remove(index);
                if (wasVisible && wasExpanded) {
                    int row = changedNode.getRow();
                    parent.resetChildrenRowsFrom(row, index, changedNode.getChildIndex());
                    changedNode = this.getNodeForPath(changedPath, false, true);
                    changedNode.expand();
                }
                if (this.treeSelectionModel != null && wasVisible && wasExpanded) {
                    this.treeSelectionModel.resetRowSelection();
                }
                if (wasVisible) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    private void visibleNodesChanged() {
    }

    private void adjustRowCountBy(int change) {
        this.rowCount += change;
    }

    private void addMapping(TreeStateNode node) {
        this.treePathMapping.put(node.getTreePath(), node);
    }

    private void removeMapping(TreeStateNode node) {
        this.treePathMapping.remove(node.getTreePath());
    }

    private TreeStateNode getMapping(TreePath path) {
        return (TreeStateNode)this.treePathMapping.get(path);
    }

    private void rebuild(boolean clearSelection) {
        Object rootUO;
        this.treePathMapping.clear();
        if (this.treeModel != null && (rootUO = this.treeModel.getRoot()) != null) {
            this.root = this.createNodeForValue(rootUO, 0);
            this.root.path = new TreePath(rootUO);
            this.addMapping(this.root);
            if (this.isRootVisible()) {
                this.rowCount = 1;
                this.root.row = 0;
            } else {
                this.rowCount = 0;
                this.root.row = -1;
            }
            this.root.expand();
        } else {
            this.root = null;
            this.rowCount = 0;
        }
        if (clearSelection && this.treeSelectionModel != null) {
            this.treeSelectionModel.clearSelection();
        }
        this.visibleNodesChanged();
    }

    private boolean ensurePathIsExpanded(TreePath aPath, boolean expandLast) {
        if (aPath != null) {
            TreeStateNode lastNode;
            if (this.treeModel.isLeaf(aPath.getLastPathComponent())) {
                aPath = aPath.getParentPath();
                expandLast = true;
            }
            if (aPath != null && (lastNode = this.getNodeForPath(aPath, false, true)) != null) {
                lastNode.makeVisible();
                if (expandLast) {
                    lastNode.expand();
                }
                return true;
            }
        }
        return false;
    }

    private TreeStateNode createNodeForValue(Object userObject, int childIndex) {
        return new TreeStateNode(userObject, childIndex, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeStateNode getNodeForPath(TreePath path, boolean onlyIfVisible, boolean shouldCreate) {
        if (path != null) {
            TreeStateNode node = this.getMapping(path);
            if (node != null) {
                if (onlyIfVisible && !node.isVisible()) {
                    return null;
                }
                return node;
            }
            if (onlyIfVisible) {
                return null;
            }
            Stack paths = this.tempStacks.size() == 0 ? new Stack() : (Stack)this.tempStacks.pop();
            try {
                paths.push(path);
                node = null;
                for (path = path.getParentPath(); path != null; path = path.getParentPath()) {
                    node = this.getMapping(path);
                    if (node != null) {
                        while (node != null && paths.size() > 0) {
                            path = (TreePath)paths.pop();
                            node = node.createChildFor(path.getLastPathComponent());
                        }
                        TreeStateNode treeStateNode = node;
                        return treeStateNode;
                    }
                    paths.push(path);
                }
            }
            finally {
                paths.removeAllElements();
                this.tempStacks.push(paths);
            }
            return null;
        }
        return null;
    }

    private final class VisibleTreeStateNodeEnumeration
    implements Enumeration {
        private TreeStateNode parent;
        private int nextIndex;
        private int childCount;

        private VisibleTreeStateNodeEnumeration(TreeStateNode node) {
            this(node, -1);
        }

        private VisibleTreeStateNodeEnumeration(TreeStateNode parent, int startIndex) {
            this.parent = parent;
            this.nextIndex = startIndex;
            this.childCount = TreeState.this.treeModel.getChildCount(this.parent.getUserObject());
        }

        public boolean hasMoreElements() {
            return this.parent != null;
        }

        public Object nextElement() {
            TreeStateNode node;
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("No more visible paths");
            }
            TreePath retObject = this.nextIndex == -1 ? this.parent.getTreePath() : ((node = this.parent.getChildAtModelIndex(this.nextIndex)) == null ? this.parent.getTreePath().pathByAddingChild(TreeState.this.treeModel.getChild(this.parent.getUserObject(), this.nextIndex)) : node.getTreePath());
            this.updateNextObject();
            return retObject;
        }

        private void updateNextObject() {
            if (!this.updateNextIndex()) {
                this.findNextValidParent();
            }
        }

        private boolean findNextValidParent() {
            if (this.parent == TreeState.this.root) {
                this.parent = null;
                return false;
            }
            while (this.parent != null) {
                TreeStateNode newParent = (TreeStateNode)this.parent.getParent();
                if (newParent != null) {
                    this.nextIndex = this.parent.childIndex;
                    this.parent = newParent;
                    this.childCount = TreeState.this.treeModel.getChildCount(this.parent.getUserObject());
                    if (!this.updateNextIndex()) continue;
                    return true;
                }
                this.parent = null;
            }
            return false;
        }

        private boolean updateNextIndex() {
            if (this.nextIndex == -1 && !this.parent.isExpanded()) {
                return false;
            }
            if (this.childCount == 0) {
                return false;
            }
            if (++this.nextIndex >= this.childCount) {
                return false;
            }
            TreeStateNode child = this.parent.getChildAtModelIndex(this.nextIndex);
            if (child != null && child.isExpanded()) {
                this.parent = child;
                this.nextIndex = -1;
                this.childCount = TreeState.this.treeModel.getChildCount(child.getUserObject());
            }
            return true;
        }
    }

    private final class SearchInfo
    implements Serializable {
        private TreeStateNode node;
        private boolean isNodeParentNode;
        private int childIndex;

        private SearchInfo() {
        }

        private TreePath getPath() {
            if (this.node == null) {
                return null;
            }
            if (this.isNodeParentNode) {
                return this.node.getTreePath().pathByAddingChild(TreeState.this.treeModel.getChild(this.node.getUserObject(), this.childIndex));
            }
            return this.node.path;
        }
    }

    private final class TreeStateNode
    extends DefaultMutableTreeNode {
        private boolean isExpanded;
        private int childIndex;
        private int childCount;
        private int row;
        private TreePath path;

        public TreeStateNode(Object userObject, int childIndex, int row) {
            super(userObject);
            this.childIndex = childIndex;
            this.row = row;
        }

        public void setParent(MutableTreeNode parent) {
            super.setParent(parent);
            if (parent != null) {
                this.path = ((TreeStateNode)parent).getTreePath().pathByAddingChild(this.getUserObject());
                TreeState.this.addMapping(this);
            }
        }

        public void remove(int childIndex) {
            TreeStateNode node = (TreeStateNode)this.getChildAt(childIndex);
            node.removeFromMapping();
            super.remove(childIndex);
        }

        public void setUserObject(Object o) {
            super.setUserObject(o);
            if (this.path != null) {
                TreeStateNode parent = (TreeStateNode)this.getParent();
                if (parent != null) {
                    this.resetChildrenPaths(parent.getTreePath());
                } else {
                    this.resetChildrenPaths(null);
                }
            }
        }

        public int getChildIndex() {
            return this.childIndex;
        }

        public TreePath getTreePath() {
            return this.path;
        }

        public TreeStateNode getChildAtModelIndex(int index) {
            for (int counter = this.getChildCount() - 1; counter >= 0; --counter) {
                if (((TreeStateNode)this.getChildAt((int)counter)).childIndex != index) continue;
                return (TreeStateNode)this.getChildAt(counter);
            }
            return null;
        }

        public boolean isVisible() {
            TreeStateNode parent = (TreeStateNode)this.getParent();
            if (parent == null) {
                return true;
            }
            return parent.isExpanded() && parent.isVisible();
        }

        public int getRow() {
            return this.row;
        }

        public int getRowToModelIndex(int index) {
            int lastRow;
            int retValue = lastRow = this.getRow() + 1;
            int maxCounter = this.getChildCount();
            for (int counter = 0; counter < maxCounter; ++counter) {
                TreeStateNode child = (TreeStateNode)this.getChildAt(counter);
                if (child.childIndex < index) continue;
                if (child.childIndex == index) {
                    return child.row;
                }
                if (counter == 0) {
                    return this.getRow() + 1 + index;
                }
                return child.row - (child.childIndex - index);
            }
            return this.getRow() + 1 + this.getTotalChildCount() - (this.childCount - index);
        }

        public int getTotalChildCount() {
            if (this.isExpanded()) {
                int pIndex;
                TreeStateNode parent = (TreeStateNode)this.getParent();
                if (parent != null && (pIndex = parent.getIndex(this)) + 1 < parent.getChildCount()) {
                    TreeStateNode nextSibling = (TreeStateNode)parent.getChildAt(pIndex + 1);
                    return nextSibling.row - this.row - (nextSibling.childIndex - this.childIndex);
                }
                int retCount = this.childCount;
                for (int counter = this.getChildCount() - 1; counter >= 0; --counter) {
                    retCount += ((TreeStateNode)this.getChildAt(counter)).getTotalChildCount();
                }
                return retCount;
            }
            return 0;
        }

        public boolean isExpanded() {
            return this.isExpanded;
        }

        public int getVisibleLevel() {
            if (TreeState.this.isRootVisible()) {
                return this.getLevel();
            }
            return this.getLevel() - 1;
        }

        private void resetChildrenPaths(TreePath parentPath) {
            TreeState.this.removeMapping(this);
            this.path = parentPath == null ? new TreePath(this.getUserObject()) : parentPath.pathByAddingChild(this.getUserObject());
            TreeState.this.addMapping(this);
            for (int counter = this.getChildCount() - 1; counter >= 0; --counter) {
                ((TreeStateNode)this.getChildAt(counter)).resetChildrenPaths(this.path);
            }
        }

        private void removeFromMapping() {
            if (this.path != null) {
                TreeState.this.removeMapping(this);
                for (int counter = this.getChildCount() - 1; counter >= 0; --counter) {
                    ((TreeStateNode)this.getChildAt(counter)).removeFromMapping();
                }
            }
        }

        private TreeStateNode createChildFor(Object userObject) {
            int newChildIndex = TreeState.this.treeModel.getIndexOfChild(this.getUserObject(), userObject);
            if (newChildIndex < 0) {
                return null;
            }
            TreeStateNode child = TreeState.this.createNodeForValue(userObject, newChildIndex);
            int childRow = this.isVisible() ? this.getRowToModelIndex(newChildIndex) : -1;
            child.row = childRow;
            int maxCounter = this.getChildCount();
            for (int counter = 0; counter < maxCounter; ++counter) {
                TreeStateNode aNode = (TreeStateNode)this.getChildAt(counter);
                if (aNode.childIndex <= newChildIndex) continue;
                this.insert(child, counter);
                return child;
            }
            this.add(child);
            return child;
        }

        private void adjustRowBy(int adjust) {
            this.row += adjust;
            if (this.isExpanded) {
                for (int counter = this.getChildCount() - 1; counter >= 0; --counter) {
                    ((TreeStateNode)this.getChildAt(counter)).adjustRowBy(adjust);
                }
            }
        }

        private void adjustRowBy(int adjust, int startIndex) {
            TreeStateNode parent;
            if (this.isExpanded) {
                for (int counter = this.getChildCount() - 1; counter >= startIndex; --counter) {
                    ((TreeStateNode)this.getChildAt(counter)).adjustRowBy(adjust);
                }
            }
            if ((parent = (TreeStateNode)this.getParent()) != null) {
                parent.adjustRowBy(adjust, parent.getIndex(this) + 1);
            }
        }

        private void didExpand() {
            int nextRow = this.setRowAndChildren(this.row);
            TreeStateNode parent = (TreeStateNode)this.getParent();
            int childRowCount = nextRow - this.row - 1;
            if (parent != null) {
                parent.adjustRowBy(childRowCount, parent.getIndex(this) + 1);
            }
            TreeState.this.adjustRowCountBy(childRowCount);
        }

        private int setRowAndChildren(int nextRow) {
            this.row = nextRow;
            if (!this.isExpanded()) {
                return this.row + 1;
            }
            int lastRow = this.row + 1;
            int lastModelIndex = 0;
            int maxCounter = this.getChildCount();
            for (int counter = 0; counter < maxCounter; ++counter) {
                TreeStateNode child = (TreeStateNode)this.getChildAt(counter);
                lastRow += child.childIndex - lastModelIndex;
                lastModelIndex = child.childIndex + 1;
                if (child.isExpanded) {
                    lastRow = child.setRowAndChildren(lastRow);
                    continue;
                }
                child.row = lastRow++;
            }
            return lastRow + this.childCount - lastModelIndex;
        }

        private void resetChildrenRowsFrom(int newRow, int childIndex, int modelIndex) {
            TreeStateNode node;
            int lastRow = newRow;
            int lastModelIndex = modelIndex;
            int maxCounter = this.getChildCount();
            for (int counter = childIndex; counter < maxCounter; ++counter) {
                node = (TreeStateNode)this.getChildAt(counter);
                lastRow += node.childIndex - lastModelIndex;
                lastModelIndex = node.childIndex + 1;
                if (node.isExpanded) {
                    lastRow = node.setRowAndChildren(lastRow);
                    continue;
                }
                node.row = lastRow++;
            }
            lastRow += this.childCount - lastModelIndex;
            node = (TreeStateNode)this.getParent();
            if (node != null) {
                node.resetChildrenRowsFrom(lastRow, node.getIndex(this) + 1, this.childIndex + 1);
            } else {
                TreeState.this.rowCount = lastRow;
            }
        }

        private void makeVisible() {
            TreeStateNode parent = (TreeStateNode)this.getParent();
            if (parent != null) {
                parent.expandParentAndReceiver();
            }
        }

        private void expandParentAndReceiver() {
            TreeStateNode parent = (TreeStateNode)this.getParent();
            if (parent != null) {
                parent.expandParentAndReceiver();
            }
            this.expand();
        }

        private void expand() {
            if (!this.isExpanded && !this.isLeaf()) {
                boolean visible = this.isVisible();
                this.isExpanded = true;
                this.childCount = TreeState.this.treeModel.getChildCount(this.getUserObject());
                if (visible) {
                    this.didExpand();
                }
                if (visible && TreeState.this.treeSelectionModel != null) {
                    TreeState.this.treeSelectionModel.resetRowSelection();
                }
            }
        }

        private void collapse(boolean adjustRows) {
            if (this.isExpanded) {
                if (this.isVisible() && adjustRows) {
                    int childCount = this.getTotalChildCount();
                    this.isExpanded = false;
                    TreeState.this.adjustRowCountBy(-childCount);
                    this.adjustRowBy(-childCount, 0);
                } else {
                    this.isExpanded = false;
                }
                if (adjustRows && this.isVisible() && TreeState.this.treeSelectionModel != null) {
                    TreeState.this.treeSelectionModel.resetRowSelection();
                }
            }
        }

        public boolean isLeaf() {
            TreeModel model = TreeState.this.getModel();
            return model != null ? model.isLeaf(this.getUserObject()) : true;
        }

        private void addNode(TreeStateNode newChild) {
            boolean added = false;
            int childIndex = newChild.getChildIndex();
            int maxCounter = this.getChildCount();
            for (int counter = 0; counter < maxCounter; ++counter) {
                if (((TreeStateNode)this.getChildAt(counter)).getChildIndex() <= childIndex) continue;
                added = true;
                this.insert(newChild, counter);
                counter = maxCounter;
            }
            if (!added) {
                this.add(newChild);
            }
        }

        private void removeChildAtModelIndex(int modelIndex, boolean isChildVisible) {
            TreeStateNode childNode = this.getChildAtModelIndex(modelIndex);
            if (childNode != null) {
                int row = childNode.getRow();
                int index = this.getIndex(childNode);
                childNode.collapse(false);
                this.remove(index);
                this.adjustChildIndexs(index, -1);
                --this.childCount;
                if (isChildVisible) {
                    this.resetChildrenRowsFrom(row, index, modelIndex);
                }
            } else {
                int maxCounter = this.getChildCount();
                for (int counter = 0; counter < maxCounter; ++counter) {
                    TreeStateNode aChild = (TreeStateNode)this.getChildAt(counter);
                    if (aChild.childIndex < modelIndex) continue;
                    if (isChildVisible) {
                        this.adjustRowBy(-1, counter);
                        TreeState.this.adjustRowCountBy(-1);
                    }
                    while (counter < maxCounter) {
                        --((TreeStateNode)this.getChildAt((int)counter)).childIndex;
                        ++counter;
                    }
                    --this.childCount;
                    return;
                }
                if (isChildVisible) {
                    this.adjustRowBy(-1, maxCounter);
                    TreeState.this.adjustRowCountBy(-1);
                }
                --this.childCount;
            }
        }

        private void adjustChildIndexs(int index, int adjust) {
            int maxCounter = this.getChildCount();
            for (int counter = index; counter < maxCounter; ++counter) {
                ((TreeStateNode)this.getChildAt((int)counter)).childIndex += adjust;
            }
        }

        private void childInsertedAtModelIndex(int index, boolean isExpandedAndVisible) {
            int maxCounter = this.getChildCount();
            for (int counter = 0; counter < maxCounter; ++counter) {
                TreeStateNode aChild = (TreeStateNode)this.getChildAt(counter);
                if (aChild.childIndex < index) continue;
                if (isExpandedAndVisible) {
                    this.adjustRowBy(1, counter);
                    TreeState.this.adjustRowCountBy(1);
                }
                while (counter < maxCounter) {
                    ++((TreeStateNode)this.getChildAt((int)counter)).childIndex;
                    ++counter;
                }
                ++this.childCount;
                return;
            }
            if (isExpandedAndVisible) {
                this.adjustRowBy(1, maxCounter);
                TreeState.this.adjustRowCountBy(1);
            }
            ++this.childCount;
        }

        private boolean getPathForRow(int row, int nextRow, SearchInfo info) {
            if (this.row == row) {
                info.node = this;
                info.isNodeParentNode = false;
                info.childIndex = this.childIndex;
                return true;
            }
            TreeStateNode lastChild = null;
            int maxCounter = this.getChildCount();
            for (int counter = 0; counter < maxCounter; ++counter) {
                TreeStateNode child = (TreeStateNode)this.getChildAt(counter);
                if (child.row > row) {
                    if (counter == 0) {
                        info.node = this;
                        info.isNodeParentNode = true;
                        info.childIndex = row - this.row - 1;
                        return true;
                    }
                    int lastChildEndRow = 1 + child.row - (child.childIndex - lastChild.childIndex);
                    if (row < lastChildEndRow) {
                        return lastChild.getPathForRow(row, lastChildEndRow, info);
                    }
                    info.node = this;
                    info.isNodeParentNode = true;
                    info.childIndex = row - lastChildEndRow + lastChild.childIndex + 1;
                    return true;
                }
                lastChild = child;
            }
            if (lastChild != null) {
                int lastChildEndRow = nextRow - (this.childCount - lastChild.childIndex) + 1;
                if (row < lastChildEndRow) {
                    return lastChild.getPathForRow(row, lastChildEndRow, info);
                }
                info.node = this;
                info.isNodeParentNode = true;
                info.childIndex = row - lastChildEndRow + lastChild.childIndex + 1;
                return true;
            }
            int retChildIndex = row - this.row - 1;
            if (retChildIndex >= this.childCount) {
                return false;
            }
            info.node = this;
            info.isNodeParentNode = true;
            info.childIndex = retChildIndex;
            return true;
        }

        private int getCountTo(int stopIndex) {
            int retCount = stopIndex + 1;
            int maxCounter = this.getChildCount();
            for (int counter = 0; counter < maxCounter; ++counter) {
                TreeStateNode aChild = (TreeStateNode)this.getChildAt(counter);
                if (aChild.childIndex >= stopIndex) {
                    counter = maxCounter;
                    continue;
                }
                retCount += aChild.getTotalChildCount();
            }
            if (this.parent != null) {
                return retCount + ((TreeStateNode)this.getParent()).getCountTo(this.childIndex);
            }
            if (!TreeState.this.isRootVisible()) {
                return retCount - 1;
            }
            return retCount;
        }

        private int getNumExpandedChildrenTo(int stopIndex) {
            int retCount = stopIndex;
            int maxCounter = this.getChildCount();
            for (int counter = 0; counter < maxCounter; ++counter) {
                TreeStateNode aChild = (TreeStateNode)this.getChildAt(counter);
                if (aChild.childIndex >= stopIndex) {
                    return retCount;
                }
                retCount += aChild.getTotalChildCount();
            }
            return retCount;
        }

        private void didAdjustTree() {
        }
    }
}

