/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.utils.groovy;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import wicket.Application;
import wicket.DefaultClassResolver;
import wicket.IClassResolver;
import wicket.WicketRuntimeException;
import wicket.contrib.utils.groovy.GroovyWarClassLoader;
import wicket.util.listener.IChangeListener;
import wicket.util.resource.IResource;
import wicket.util.watch.IModifiable;
import wicket.util.watch.ModificationWatcher;

public class GroovyClassResolver
implements IClassResolver {
    private static final Log log = LogFactory.getLog((Class)(class$wicket$contrib$utils$groovy$GroovyClassResolver == null ? (class$wicket$contrib$utils$groovy$GroovyClassResolver = GroovyClassResolver.class$("wicket.contrib.utils.groovy.GroovyClassResolver")) : class$wicket$contrib$utils$groovy$GroovyClassResolver));
    private final Map classCache = new ConcurrentHashMap();
    private final IClassResolver defaultClassResolver = new DefaultClassResolver();
    private final Application application;
    static /* synthetic */ Class class$wicket$contrib$utils$groovy$GroovyClassResolver;

    public GroovyClassResolver(Application application) {
        this.application = application;
    }

    public Class resolveClass(String classname) {
        try {
            return this.defaultClassResolver.resolveClass(classname);
        }
        catch (WicketRuntimeException ex) {
            block7: {
                Class groovyPageClass = (Class)this.classCache.get(classname);
                if (groovyPageClass != null) {
                    return groovyPageClass;
                }
                IResource resource = this.application.getResourceLocator().locate(classname, null, null, ".groovy");
                if (resource != null) {
                    try {
                        groovyPageClass = this.loadGroovyFileAndWatchForChanges(classname, resource);
                        if (groovyPageClass != null) {
                            return groovyPageClass;
                        }
                        break block7;
                    }
                    catch (WicketRuntimeException ex2) {
                        throw new WicketRuntimeException("Unable to load class with name: " + classname, (Throwable)ex2);
                    }
                }
                throw new WicketRuntimeException("File not found: " + resource);
            }
            throw new WicketRuntimeException("Unable to load class with name: " + classname);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Class loadGroovyFile(String classname, IResource resource) {
        Class clazz;
        block13: {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = (class$wicket$contrib$utils$groovy$GroovyClassResolver == null ? (class$wicket$contrib$utils$groovy$GroovyClassResolver = GroovyClassResolver.class$("wicket.contrib.utils.groovy.GroovyClassResolver")) : class$wicket$contrib$utils$groovy$GroovyClassResolver).getClassLoader();
            }
            GroovyWarClassLoader groovyClassLoader = new GroovyWarClassLoader(cl);
            clazz = null;
            try {
                block12: {
                    try {
                        InputStream in = resource.getInputStream();
                        if (in != null) {
                            clazz = groovyClassLoader.parseClass(in);
                            if (clazz != null) {
                                if (!classname.equals(clazz.getName())) {
                                    log.warn((Object)"Though it is possible, the Groovy file name and the java class name defined in that file SHOULD match and follow the java rules");
                                }
                                classname = clazz.getName();
                            }
                            break block12;
                        }
                        log.warn((Object)("Groovy file not found: " + resource));
                    }
                    catch (CompilationFailedException e) {
                        throw new WicketRuntimeException("Error parsing groovy file: " + resource, (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new WicketRuntimeException("Error reading groovy file: " + resource, (Throwable)e);
                    }
                    catch (Throwable e) {
                        throw new WicketRuntimeException("Error while reading groovy file: " + resource, e);
                    }
                }
                Object var8_10 = null;
                if (clazz != null) break block13;
                this.classCache.remove(classname);
                return clazz;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (clazz == null) {
                    this.classCache.remove(classname);
                    throw throwable;
                }
                this.classCache.put(classname, clazz);
                throw throwable;
            }
        }
        this.classCache.put(classname, clazz);
        return clazz;
    }

    private Class loadGroovyFileAndWatchForChanges(final String classname, final IResource resource) {
        ModificationWatcher watcher = this.application.getResourceWatcher();
        if (watcher != null) {
            watcher.add((IModifiable)resource, new IChangeListener(){

                public void onChange() {
                    try {
                        log.info((Object)("Reloading groovy file from " + resource));
                        Class clazz = GroovyClassResolver.this.loadGroovyFile(classname, resource);
                        log.debug((Object)("Groovy file contained definition for class: " + clazz.getName()));
                    }
                    catch (Exception e) {
                        log.error((Object)("Unable to load groovyy file: " + resource), (Throwable)e);
                    }
                }
            });
        }
        log.info((Object)("Loading groovy file from " + resource));
        return this.loadGroovyFile(classname, resource);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

