/*
 * Decompiled with CFR 0.152.
 */
package jfun.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class DateUtil {
    public static Locale parseLocale(String str) {
        StringTokenizer st = new StringTokenizer(str, " \t\n\r\f,");
        try {
            String language = st.nextToken();
            String country = null;
            String variant = null;
            if (st.hasMoreElements()) {
                country = st.nextToken();
                if (st.hasMoreElements()) {
                    variant = st.nextToken();
                    if (st.hasMoreElements()) {
                        throw new IllegalArgumentException("bad locale format");
                    }
                }
            } else {
                country = "";
            }
            if (variant == null) {
                return new Locale(language, country);
            }
            return new Locale(language, country, variant);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("bad locale format: " + e.getMessage());
        }
    }

    public static DateFormat getDateFormat(String pattern, Locale locale) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern must be provided for formatting Date");
        }
        if (locale == null) {
            return new SimpleDateFormat(pattern);
        }
        return new SimpleDateFormat(pattern, locale);
    }

    public static DateFormat getDateFormat(String pattern, Locale locale, TimeZone tzone) {
        DateFormat df = DateUtil.getDateFormat(pattern, locale);
        if (tzone != null) {
            df.setTimeZone(tzone);
        }
        return df;
    }
}

