/*
 * Decompiled with CFR 0.152.
 */
package jfun.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;

public class SerializableConstructor
implements Serializable {
    private transient Constructor ctor;

    public SerializableConstructor(Constructor ctor) {
        this.ctor = ctor;
    }

    public Constructor getConstructor() {
        return this.ctor;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.ctor.getDeclaringClass());
        out.writeObject(this.ctor.getParameterTypes());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            Class c = (Class)in.readObject();
            Class[] ptypes = (Class[])in.readObject();
            this.ctor = c.getDeclaredConstructor(ptypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SerializableConstructor) {
            SerializableConstructor other = (SerializableConstructor)obj;
            return this.ctor.equals(other.ctor);
        }
        return false;
    }

    public int hashCode() {
        return this.ctor.hashCode();
    }

    public String toString() {
        return this.ctor.toString();
    }
}

