/*
 * Decompiled with CFR 0.152.
 */
package jfun.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;

public class SerializableField
implements Serializable {
    private transient Field fld;

    public SerializableField(Field fld) {
        this.fld = fld;
    }

    public Field getField() {
        return this.fld;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.fld.getDeclaringClass());
        out.writeObject(this.fld.getName());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            Class c = (Class)in.readObject();
            String name = (String)in.readObject();
            this.fld = c.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SerializableField) {
            SerializableField other = (SerializableField)obj;
            return this.fld.equals(other.fld);
        }
        return false;
    }

    public int hashCode() {
        return this.fld.hashCode();
    }

    public String toString() {
        return this.fld.toString();
    }
}

