/*
 * Decompiled with CFR 0.152.
 */
package jfun.util.dict;

import java.io.Serializable;
import java.util.Map;
import jfun.util.List;
import jfun.util.dict.Dict;
import jfun.util.dict.DictContainer;
import jfun.util.dict.DictEmpty;
import jfun.util.dict.DictProxy;
import jfun.util.dict.DictProxyMigrator;
import jfun.util.dict.Update;
import jfun.util.dict.Utils;

class Dictionary
implements DictProxy,
DictProxyMigrator,
Serializable {
    private DictContainer state;

    public DictProxy noChange() {
        return this;
    }

    public DictProxy changed() {
        return this.create();
    }

    Dictionary() {
    }

    public String toString() {
        Object[] ks = this.keys();
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        if (ks.length > 0) {
            buf.append(ks[0]).append('=').append(this.get(ks[0]));
            for (int i = 1; i < ks.length; ++i) {
                buf.append(", ").append(ks[i]).append('=').append(this.get(ks[i]));
            }
        }
        buf.append('}');
        return buf.toString();
    }

    public DictProxy apply(DictProxyMigrator migrator, Update upd) {
        return this.state.apply(migrator, upd);
    }

    public DictProxy apply(DictProxyMigrator migrator, List updates) {
        return this.state.apply(migrator, updates);
    }

    public DictProxy puts(DictProxyMigrator migrator, Object[] keys, Object[] vals) {
        return this.state.puts(migrator, keys, vals);
    }

    public DictProxy removes(DictProxyMigrator migrator, Object[] keys) {
        return this.state.removes(migrator, keys);
    }

    public final Dict copy() {
        return this.cloneDict();
    }

    public Dict cloneDict() {
        this.touch();
        return this.state.clone(this.createNew());
    }

    public boolean containsKey(Object key) {
        this.touch();
        return this.state.containsKey(key);
    }

    public Map getUnderlying() {
        this.touch();
        return this.state.getUnderlying();
    }

    public int hashCode() {
        return ((Object)this.getUnderlying()).hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Dictionary) {
            Dictionary d = (Dictionary)other;
            return ((Object)this.getUnderlying()).equals(d.getUnderlying());
        }
        if (other instanceof DictEmpty) {
            return this.isEmpty();
        }
        if (other instanceof Dict) {
            Dict dict = (Dict)other;
            if (this.size() != dict.size()) {
                return false;
            }
            Object[] ks = this.keys();
            for (int i = 0; i < ks.length; ++i) {
                Object uval;
                Object key = ks[i];
                Object myval = this.get(key);
                if (myval.equals(uval = dict.get(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    DictProxy create() {
        return new Dictionary();
    }

    DictProxy createNew() {
        return new Dictionary();
    }

    public Object get(Object key) {
        this.touch();
        return this.state.get(key);
    }

    public boolean isEmpty() {
        this.touch();
        return this.state.isEmpty();
    }

    public Object[] keys() {
        this.touch();
        return this.state.keys();
    }

    public Object[] values() {
        this.touch();
        return this.state.values();
    }

    public Map.Entry[] entries() {
        this.touch();
        return this.state.entries();
    }

    public Object[] keys(Object[] buf) {
        this.touch();
        return this.state.keys(buf);
    }

    public Object[] values(Object[] buf) {
        this.touch();
        return this.state.values(buf);
    }

    public Dict put(Object key, Object val) {
        this.touch();
        return this.state.put(this, key, val);
    }

    public Dict remove(Object key) {
        this.touch();
        return this.state.remove(this, key);
    }

    public Dict puts(Object[] keys, Object[] vals) {
        Utils.checkKeyValues(keys, vals);
        this.touch();
        return this.state.puts(this, keys, vals);
    }

    public Dict removes(Object[] keys) {
        this.touch();
        return this.state.removes(this, keys);
    }

    public void setState(DictContainer state) {
        this.state = state;
    }

    public int size() {
        this.touch();
        return this.state.size();
    }

    private final void touch() {
        this.state.touch(this);
    }

    public void initUnderlying(Map m) {
    }
}

