/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.validation.CharValidator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EntityResolver {
    public static final String AMP_ESCAPE = "&amp;";
    public static final String LT_ESCAPE = "&lt;";
    public static final String GT_ESCAPE = "&gt;";
    public static final String QUOT_ESCAPE = "&quot;";
    public static final String APOS_ESCAPE = "&apos;";
    private EntityResolver parent;
    protected Map<String, String> resolveMap = new LinkedHashMap<String, String>(256);
    private CharValidator charValidator = new CharValidator();

    public EntityResolver() {
        this.clear();
    }

    public EntityResolver(EntityResolver parent) {
        this.parent = parent;
        this.clear();
    }

    public EntityResolver getParent() {
        return this.parent;
    }

    public CharValidator getCharValidator() {
        if (this.charValidator == null) {
            return this.parent == null ? null : this.parent.getCharValidator();
        }
        return this.charValidator;
    }

    public EntityResolver setCharValidator(CharValidator charValidator) {
        this.charValidator = charValidator;
        return this;
    }

    public void clear() {
        this.resolveMap.clear();
        this.resolveMap.put("lt", "<");
        this.resolveMap.put("gt", ">");
        this.resolveMap.put("amp", "&");
        this.resolveMap.put("quot", "\"");
        this.resolveMap.put("apos", "'");
    }

    public void add(String name, String replacementText) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("name is null or empty");
        }
        if (replacementText == null) {
            throw new IllegalArgumentException("replacementText is null");
        }
        this.resolveMap.put(name, replacementText);
    }

    public boolean isDefined(String name) {
        if (this.resolveMap.containsKey(name = this.stripName(name))) {
            return true;
        }
        return this.parent == null ? false : this.parent.isDefined(name);
    }

    public String resolve(String name) {
        String result = this.resolveMap.get(name = this.stripName(name));
        if (result == null && this.parent != null) {
            result = this.parent.resolve(name);
        }
        return result;
    }

    protected String stripName(String name) {
        if (name.startsWith("&") && name.endsWith(";")) {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    public String expand(String entity) {
        if (entity.startsWith("&#")) {
            int codePoint = this.expandNumericEntity(entity);
            return new String(Character.toChars(codePoint));
        }
        String name = this.stripName(entity);
        if (!this.isDefined(name)) {
            return null;
        }
        return this.resolve(name);
    }

    public String encode(String input) {
        StringBuilder buffer = new StringBuilder(this.resolveMap.size() * 8);
        String delim = "(";
        HashMap<String, String> reverseMap = new HashMap<String, String>(this.resolveMap.size());
        for (Map.Entry<String, String> entry : this.resolveMap.entrySet()) {
            String value = entry.getValue();
            reverseMap.put(value, entry.getKey());
            buffer.append(delim);
            delim = "|";
            buffer.append(Pattern.quote(value));
        }
        buffer.append(")");
        Pattern p = Pattern.compile(buffer.toString());
        buffer.setLength(0);
        Matcher match = p.matcher(input);
        int pos = 0;
        while (match.find()) {
            int startPos = match.start();
            buffer.append(input.substring(pos, startPos));
            String reverseKey = match.group();
            buffer.append("&");
            buffer.append((String)reverseMap.get(reverseKey));
            buffer.append(";");
            pos = match.end();
        }
        buffer.append(input.substring(pos));
        return buffer.toString();
    }

    public int expandNumericEntity(String entity) {
        boolean isHex;
        int value;
        if (!entity.endsWith(";")) {
            throw new IllegalArgumentException("Entities must end with ';': [" + entity + "]");
        }
        if (entity.startsWith("&#x")) {
            try {
                value = Integer.parseInt(entity.substring(3, entity.length() - 1), 16);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Value of hexadecimal entity can't be parsed: [" + entity + "]", e);
            }
            isHex = true;
        } else if (entity.startsWith("&#")) {
            try {
                value = Integer.parseInt(entity.substring(2, entity.length() - 1), 10);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Value of decimal entity can't be parsed: [" + entity + "]", e);
            }
            isHex = false;
        } else {
            throw new IllegalArgumentException("Entities must start with '&#' or '&#x': [" + entity + "]");
        }
        if (value < 0) {
            throw new IllegalArgumentException("Value of numeric entity must be > 0: [" + entity + "]");
        }
        if (this.charValidator != null) {
            String msg = this.charValidator.isValid(value);
            if (msg == null) {
                return value;
            }
            throw new IllegalArgumentException("Illegal value for numeric entity. " + msg);
        }
        if (value <= 0x10FFFF) {
            return value;
        }
        throw new IllegalArgumentException("Value of numeric entity must be [#x0000-#x10FFFF]: [" + entity + "]" + (isHex ? "" : " (0x" + Integer.toHexString(value) + ")"));
    }

    public void validateEntity(String entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity is null");
        }
        if (entity.length() <= 2) {
            throw new IllegalArgumentException("Entity is too short");
        }
        if (!entity.startsWith("&")) {
            throw new IllegalArgumentException("Entity doesn't begin with '&': '" + entity + "'");
        }
        if (!entity.endsWith(";")) {
            throw new IllegalArgumentException("Entity doesn't end with ';': '" + entity + "'");
        }
        if (entity.charAt(1) == '#') {
            this.expandNumericEntity(entity);
        } else {
            CharValidator v = this.getCharValidator();
            if (!v.isNameStartChar(entity.charAt(1))) {
                throw new IllegalArgumentException("Entity name doesn't begin with a valid character: '" + entity + "'");
            }
            int N = entity.length() - 1;
            for (int i = 2; i < N; ++i) {
                if (v.isNameChar(entity.charAt(i))) continue;
                String s = "";
                if (i + 1 < N) {
                    s = entity.substring(i + 1);
                }
                s = entity.substring(0, i) + "_" + entity.charAt(i) + "_" + s;
                throw new IllegalArgumentException("Character " + i + " of entity name is invalid: '" + entity + "'");
            }
        }
    }
}

