/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camel.tooling.util;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Node;
import io.fabric8.camel.tooling.util.CamelNamespaces;
import io.fabric8.camel.tooling.util.ValidationException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidationHandler
implements ErrorHandler {
    List<SAXParseException> warnings = new LinkedList<SAXParseException>();
    List<SAXParseException> errors = new LinkedList<SAXParseException>();
    List<SAXParseException> fatalErrors = new LinkedList<SAXParseException>();

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.warnings.add(exception);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.errors.add(exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.fatalErrors.add(exception);
    }

    public List<SAXParseException> getWarnings() {
        return this.warnings;
    }

    public List<SAXParseException> getErrors() {
        return this.errors;
    }

    public List<SAXParseException> getFatalErrors() {
        return this.fatalErrors;
    }

    public String userMessage() {
        StringWriter sw = new StringWriter();
        for (SAXParseException ex : this.errors) {
            sw.append(", ").append(ex.getMessage());
        }
        for (SAXParseException ex : this.fatalErrors) {
            sw.append(", ").append(ex.getMessage());
        }
        String text = sw.toString();
        if (text.length() > 2) {
            text = text.substring(2);
        }
        int idx = text.indexOf(":");
        if (text.startsWith("cvc-complex-type") && idx > 0) {
            text = text.substring(idx + 1).trim();
        }
        for (String uri : CamelNamespaces.camelNamespaces) {
            text = text.replaceAll("\"" + uri + "\":", "");
        }
        return text;
    }

    public void validate(Document doc) throws IOException, SAXException {
        Validator validator = CamelNamespaces.camelSchemas().newValidator();
        validator.setErrorHandler(this);
        this.validate(validator, doc.getRootElement());
    }

    private void validate(Validator validator, Element e) throws IOException, SAXException {
        String uri = CamelNamespaces.getNamespaceURI(e);
        if (uri != null && Arrays.asList(CamelNamespaces.camelNamespaces).contains(uri)) {
            String text = CamelNamespaces.nodeWithNamespacesToText(e, e);
            validator.validate(new StreamSource(new StringReader(text)));
        } else {
            for (Node node : e.getNodes()) {
                if (!(node instanceof Element)) continue;
                this.validate(validator, (Element)node);
            }
        }
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty() || !this.fatalErrors.isEmpty();
    }

    public void checkForErrors() throws ValidationException {
        if (this.hasErrors()) {
            StringWriter sw = new StringWriter();
            for (SAXParseException ex : this.errors) {
                sw.append(", ").append(ex.getMessage());
            }
            for (SAXParseException ex : this.fatalErrors) {
                sw.append(", ").append(ex.getMessage());
            }
            String text = sw.toString();
            if (text.length() > 2) {
                text = text.substring(2);
            }
            throw new ValidationException("Validation failed: " + text, this.userMessage(), this.errors, this.fatalErrors, this.warnings);
        }
    }
}

