/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.BasicNode;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.TextNode;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLParseException;
import de.pdark.decentxml.XMLTokenizer;

public class ProcessingInstruction
extends BasicNode
implements TextNode {
    private String target;
    private String whitespace;
    private String text;

    public ProcessingInstruction(Token token) {
        super(token);
        int pos;
        char c;
        int pos2;
        String xml = token.getText();
        for (pos2 = pos = 2; pos2 < xml.length() && !Character.isWhitespace(c = xml.charAt(pos2)) && c != '?'; ++pos2) {
        }
        if (pos == pos2) {
            throw new XMLParseException("Missing target name in processing instruction", token);
        }
        this.target = xml.substring(pos, pos2);
        while (pos2 < xml.length() && Character.isWhitespace(c = xml.charAt(pos2)) && c != '?') {
            ++pos2;
        }
        pos = Math.min(pos2, xml.length() - 2);
        pos2 = xml.length() - 2;
        this.text = xml.substring(pos, pos2);
    }

    public ProcessingInstruction(String target) {
        this(target, null);
    }

    public ProcessingInstruction(String target, String text) {
        super(XMLTokenizer.Type.PROCESSING_INSTRUCTION, null);
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (target.trim().length() == 0) {
            throw new IllegalArgumentException("target is blank or empty");
        }
        if (text == null) {
            text = "";
        }
        if (text.contains("?>")) {
            throw new IllegalArgumentException("text must not contain '?>'");
        }
        this.target = target.trim();
        this.whitespace = "";
        this.text = text;
        this.updateValue();
    }

    protected void updateValue() {
        char c;
        int pos;
        for (pos = 0; pos < this.text.length() && Character.isWhitespace(c = this.text.charAt(pos)); ++pos) {
        }
        this.whitespace = pos == 0 && this.text.length() != 0 ? " " : "";
        this.setValue("<?" + this.target + this.whitespace + this.text + "?>");
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        this.updateValue();
    }

    public String getText() {
        return this.text;
    }

    public ProcessingInstruction setText(String text) {
        this.text = text;
        this.updateValue();
        return this;
    }

    public ProcessingInstruction createClone() {
        return new ProcessingInstruction(this.target, this.text);
    }

    public ProcessingInstruction copy(Node orig) {
        super.copy(orig);
        ProcessingInstruction other = (ProcessingInstruction)orig;
        this.target = other.target;
        this.text = other.text;
        this.whitespace = other.whitespace;
        return this;
    }

    public ProcessingInstruction copy() {
        return (ProcessingInstruction)super.copy();
    }
}

