/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camel.tooling.util;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Node;
import io.fabric8.camel.tooling.util.CamelNamespaces;
import io.fabric8.camel.tooling.util.ValidationHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spring.CamelContextFactoryBean;
import org.apache.camel.spring.CamelEndpointFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class XmlModel {
    public static Logger LOG = LoggerFactory.getLogger(XmlModel.class);
    private CamelContextFactoryBean contextElement;
    private Document doc;
    private Map<String, String> beans;
    private Node node;
    private String ns;
    private boolean justRoutes;
    private boolean routesContext;

    public XmlModel(CamelContextFactoryBean contextElement, Document doc, Map<String, String> beans, Node node, String ns, boolean justRoutes, boolean routesContext) {
        this.contextElement = contextElement;
        this.doc = doc;
        this.beans = beans;
        this.node = node;
        this.ns = ns;
        this.justRoutes = justRoutes;
        this.routesContext = routesContext;
    }

    public CamelContextFactoryBean getContextElement() {
        return this.contextElement;
    }

    public Document getDoc() {
        return this.doc;
    }

    public Map<String, String> getBeans() {
        return this.beans;
    }

    public Node getNode() {
        return this.node;
    }

    public String getNs() {
        return this.ns;
    }

    public boolean isJustRoutes() {
        return this.justRoutes;
    }

    public boolean isRoutesContext() {
        return this.routesContext;
    }

    public Object marshalRootElement() {
        if (this.justRoutes) {
            RoutesDefinition routes = new RoutesDefinition();
            routes.setRoutes(this.contextElement.getRoutes());
            return routes;
        }
        return this.contextElement;
    }

    public void update(CamelContextFactoryBean newContext) {
        this.contextElement = newContext;
    }

    public List<RouteDefinition> getRouteDefinitionList() {
        return this.contextElement.getRoutes();
    }

    public boolean hasMissingId() {
        for (RouteDefinition rd : this.getRouteDefinitionList()) {
            if (rd.getId() != null) continue;
            return true;
        }
        return false;
    }

    public CamelContext createContext(Collection<RouteDefinition> routes) throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addRouteDefinitions(routes);
        return context;
    }

    public CamelContext camelContext() throws Exception {
        return this.createContext(this.contextElement.getRoutes());
    }

    public Set<String> endpointUris() {
        try {
            List<Node> sessions;
            List endpoints = this.contextElement.getEndpoints();
            LinkedList<String> uris = new LinkedList<String>();
            if (endpoints != null) {
                for (CamelEndpointFactoryBean cefb : endpoints) {
                    uris.add(cefb.getUri());
                }
            }
            if ((sessions = CamelNamespaces.nodesByNamespace(this.doc, CamelNamespaces.droolsNamespace.getURI(), "ksession")) != null) {
                for (Node session : sessions) {
                    if (!(session instanceof Element)) continue;
                    Element e = (Element)session;
                    String node = e.getAttributeValue("node");
                    String sid = e.getAttributeValue("id");
                    if (node == null || node.length() <= 0 || sid == null || sid.length() <= 0) continue;
                    String du = "drools:" + node + "/" + sid;
                    boolean exists = false;
                    for (String uri : uris) {
                        if (!uri.startsWith(du)) continue;
                        exists = true;
                    }
                    if (exists) continue;
                    uris.add(du);
                }
            }
            return new TreeSet<String>(uris);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new HashSet<String>();
        }
    }

    public Set<String> endpointUriSet() {
        return this.endpointUris();
    }

    public Map<String, String> beanMap() {
        return this.beans;
    }

    public ValidationHandler validate() throws IOException, SAXException {
        ValidationHandler v = new ValidationHandler();
        v.validate(this.doc);
        return v;
    }
}

