/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.EntityResolver;
import de.pdark.decentxml.TextUtils;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLParseException;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.validation.CharValidator;

public class XMLTokenizer {
    protected final XMLSource source;
    protected int pos;
    protected boolean inStartElement;
    private boolean treatEntitiesAsText = true;
    private CharValidator charValidator = new CharValidator();
    private EntityResolver entityResolver;

    public XMLTokenizer(XMLSource source) {
        this.source = source;
    }

    public XMLTokenizer setTreatEntitiesAsText(boolean treatEntitiesAsText) {
        this.treatEntitiesAsText = treatEntitiesAsText;
        return this;
    }

    public boolean isTreatEntitiesAsText() {
        return this.treatEntitiesAsText;
    }

    public CharValidator getCharValidator() {
        return this.charValidator;
    }

    public XMLTokenizer setCharValidator(CharValidator charValidator) {
        if (charValidator == null) {
            throw new IllegalArgumentException("charValidator is null");
        }
        this.charValidator = charValidator;
        return this;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public XMLTokenizer setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
        return this;
    }

    public Token next() {
        if (this.pos >= this.source.length()) {
            return null;
        }
        Token token = this.createToken();
        char c = this.source.charAt(this.pos);
        if (this.inStartElement) {
            this.skipWhiteSpace();
            c = this.source.charAt(this.pos);
            if (c == '>') {
                ++this.pos;
                token.setType(Type.BEGIN_ELEMENT_END);
                this.inStartElement = false;
            } else if (c == '/') {
                ++this.pos;
                if (this.pos >= this.source.length() || this.source.charAt(this.pos) != '>') {
                    throw new XMLParseException("Expected '/>'", this.source, this.pos - 1);
                }
                ++this.pos;
                token.setType(Type.BEGIN_ELEMENT_END);
                this.inStartElement = false;
            } else {
                this.parseAttribute(token);
            }
        } else if (c == '<') {
            ++this.pos;
            this.parseBeginSomething(token);
        } else if (!this.treatEntitiesAsText && c == '&') {
            ++this.pos;
            this.parseEntity(token);
        } else {
            this.parseText(token);
        }
        token.setEndOffset(this.pos);
        return token;
    }

    protected Token createToken() {
        Token token = new Token();
        token.setSource(this.source);
        token.setStartOffset(this.pos);
        return token;
    }

    public XMLSource getSource() {
        return this.source;
    }

    public int getOffset() {
        return this.pos;
    }

    public void setOffset(int offset) {
        this.pos = offset;
    }

    protected void parseBeginSomething(Token token) {
        if (this.pos >= this.source.length()) {
            throw new XMLParseException("Unexpected end of input. Expected start or end tag, processing instruction, comment or CDATA", this.source, this.pos);
        }
        char c = this.source.charAt(this.pos);
        switch (c) {
            case '?': {
                ++this.pos;
                this.parseProcessingInstruction(token);
                break;
            }
            case '!': {
                ++this.pos;
                this.parseExcalamation(token);
                break;
            }
            case '/': {
                ++this.pos;
                this.parseEndElement(token);
                break;
            }
            default: {
                this.parseBeginElement(token);
            }
        }
    }

    protected void parseBeginElement(Token token) {
        token.setType(Type.BEGIN_ELEMENT);
        this.inStartElement = true;
        this.skipWhiteSpace();
        int nameStartOffset = this.pos;
        this.parseName("start tag");
        if (this.pos == nameStartOffset) {
            throw new XMLParseException("Missing element name", token);
        }
        if (this.pos >= this.source.length()) {
            throw new XMLParseException("Missing '>' of start tag", this.source, this.pos);
        }
        char c = this.source.charAt(this.pos);
        if (!this.charValidator.isWhitespace(c) && c != '/' && c != '>') {
            throw new XMLParseException("Expected whitespace, '>' or '/>' after element name", this.source, this.pos);
        }
    }

    protected void parseEndElement(Token token) {
        token.setType(Type.END_ELEMENT);
        this.skipWhiteSpace();
        this.parseName("end tag");
        this.skipWhiteSpace();
        this.expect('>');
    }

    protected void parseExcalamation(Token token) {
        char c = this.source.charAt(this.pos);
        if (c == '-') {
            ++this.pos;
            this.parseComment(token);
        } else if (c == '[') {
            ++this.pos;
            this.parseCData(token);
        } else if (c == 'D') {
            ++this.pos;
            this.parseDocType(token);
        } else {
            throw new XMLParseException("Expected '<!--' or '<![CDATA['", this.source, this.pos - 2);
        }
    }

    protected void parseDocType(Token token) {
        token.setType(Type.DOCTYPE);
        this.nextChars("<!DOCTYPE", this.pos - 3, "Expected '<!DOCTYPE'");
    }

    protected void parseCData(Token token) {
        token.setType(Type.CDATA);
        this.nextChars("<![CDATA[", this.pos - 3, "Expected '<![CDATA['");
        while (true) {
            if (this.pos >= this.source.length()) {
                throw new XMLParseException("Expected ']]>'", this.source, this.pos);
            }
            char c = this.source.charAt(this.pos);
            if (c == ']') {
                int errorPos = this.pos++;
                if (this.pos + 1 >= this.source.length()) {
                    throw new XMLParseException("Expected ']]>'" + this.lookAheadForErrorMessage("but found", errorPos, 20), this.source, errorPos);
                }
                c = this.source.charAt(this.pos);
                if (c != ']' || (c = this.source.charAt(this.pos + 1)) != '>') continue;
                this.pos += 2;
                break;
            }
            String msg = this.charValidator.isValid(this.source, this.pos);
            if (msg != null) {
                throw new XMLParseException("Illegal character found in CDATA. " + msg, this.source, this.pos);
            }
            this.skipChar(c);
        }
    }

    protected void parseComment(Token token) {
        token.setType(Type.COMMENT);
        if (this.pos >= this.source.length() || this.source.charAt(this.pos) != '-') {
            throw new XMLParseException("Expected '<!--'", this.source, this.pos - 3);
        }
        ++this.pos;
        while (true) {
            if (this.pos >= this.source.length()) {
                throw new XMLParseException("Expected '-->'", this.source, this.pos);
            }
            char c = this.source.charAt(this.pos);
            if (c == '-') {
                ++this.pos;
                if (this.pos >= this.source.length()) {
                    throw new XMLParseException("Expected '-->'", this.source, this.pos - 1);
                }
                if ((c = this.source.charAt(this.pos++)) != '-') continue;
                if (this.pos >= this.source.length()) {
                    throw new XMLParseException("Expected '-->'", this.source, this.pos - 2);
                }
                if ((c = this.source.charAt(this.pos++)) == '>') break;
                throw new XMLParseException("XML comments must not contain '--'", this.source, this.pos - 3);
            }
            String msg = this.charValidator.isValid(this.source, this.pos);
            if (msg != null) {
                throw new XMLParseException("Illegal character found in comment. " + msg, this.source, this.pos);
            }
            this.skipChar(c);
        }
    }

    protected void parseProcessingInstruction(Token token) {
        token.setType(Type.PROCESSING_INSTRUCTION);
        int errorPos = this.pos - 2;
        while (true) {
            if (this.pos >= this.source.length()) {
                throw new XMLParseException("Missing end of processing instruction", this.source, errorPos);
            }
            char c = this.source.charAt(this.pos);
            if (c == '?') {
                ++this.pos;
                if (this.pos >= this.source.length()) {
                    throw new XMLParseException("Expected '>' after '?'", this.source, this.pos);
                }
                if (this.source.charAt(this.pos) != '>') continue;
                ++this.pos;
                break;
            }
            String msg = this.charValidator.isValid(this.source, this.pos);
            if (msg != null) {
                throw new XMLParseException("Illegal character found in processing instruction. " + msg, this.source, this.pos);
            }
            this.skipChar(c);
        }
    }

    protected void parseAttribute(Token token) {
        token.setType(Type.ATTRIBUTE);
        this.parseName("attribute");
        if (this.pos == token.getStartOffset()) {
            throw new XMLParseException("Expected attribute name", this.source, this.pos);
        }
        this.skipWhiteSpace();
        this.expect('=');
        this.skipWhiteSpace();
        char c = '\u0000';
        if (this.pos < this.source.length()) {
            c = this.source.charAt(this.pos);
        }
        if (c != '\'' && c != '\"') {
            throw new XMLParseException("Expected single or double quotes", this.source, this.pos);
        }
        char endChar = c;
        boolean insideEntity = false;
        int errorPos = this.pos;
        while (true) {
            ++this.pos;
            if (this.pos >= this.source.length()) {
                int i = Math.min(20, this.source.length() - token.getStartOffset());
                throw new XMLParseException("Missing end quote (" + endChar + ") of attribute: " + this.lookAheadForErrorMessage(null, token.getStartOffset(), i), token);
            }
            c = this.source.charAt(this.pos);
            if (c == endChar) break;
            if (c == '<' || c == '>') {
                throw new XMLParseException("Illegal character in attribute value: '" + c + "'", this.source, this.pos);
            }
            if (c == '&') {
                insideEntity = true;
                errorPos = this.pos;
                continue;
            }
            if (c == ';') {
                this.verifyEntity(errorPos, this.pos + 1);
                insideEntity = false;
                continue;
            }
            String msg = this.charValidator.isValid(this.source, this.pos);
            if (msg != null) {
                throw new XMLParseException("Illegal character found in attribute value. " + msg, this.source, this.pos);
            }
            this.skipChar(c);
            --this.pos;
        }
        if (insideEntity) {
            throw new XMLParseException("Missing ';' after '&': " + this.lookAheadForErrorMessage(null, errorPos, 20), this.source, errorPos);
        }
        ++this.pos;
    }

    protected void parseName(String objectName) {
        int startPos = this.pos;
        if (this.pos < this.source.length() && this.charValidator.isNameStartChar(this.source.charAt(this.pos))) {
            ++this.pos;
            while (this.pos < this.source.length() && this.charValidator.isNameChar(this.source.charAt(this.pos))) {
                ++this.pos;
            }
        }
        if (this.pos == startPos) {
            throw new XMLParseException("Expected valid XML name for " + objectName + this.lookAheadForErrorMessage("but found", startPos, 20), this.source, startPos);
        }
    }

    protected void parseText(Token token) {
        char c;
        token.setType(Type.TEXT);
        int errorPos = this.pos - 1;
        boolean insideEntity = false;
        while (this.pos < this.source.length() && (c = this.source.charAt(this.pos)) != '<') {
            if (c == '&') {
                if (!this.treatEntitiesAsText) break;
                errorPos = this.pos;
                insideEntity = true;
            } else if (c == ';') {
                if (insideEntity) {
                    this.verifyEntity(errorPos, this.pos + 1);
                }
                insideEntity = false;
            } else if (c == ']' && this.pos + 2 < this.source.length() && this.source.charAt(this.pos + 1) == ']' && this.source.charAt(this.pos + 2) == '>') {
                throw new XMLParseException("Please replace the '>' of ']]>' in character data with '&gt;'", this.source, this.pos + 2);
            }
            String msg = this.charValidator.isValid(this.source, this.pos);
            if (msg != null) {
                throw new XMLParseException("Illegal character found in text. " + msg, this.source, this.pos);
            }
            this.skipChar(c);
        }
        if (insideEntity) {
            throw new XMLParseException("Missing ';' after '&': " + this.lookAheadForErrorMessage(null, errorPos, 20), this.source, errorPos);
        }
    }

    protected void skipChar(char c) {
        ++this.pos;
        if (Character.isHighSurrogate(c)) {
            ++this.pos;
        }
    }

    protected void verifyEntity(int start, int end) {
        if (this.entityResolver == null) {
            return;
        }
        String entity = this.source.substring(start, end);
        try {
            this.entityResolver.validateEntity(entity);
        }
        catch (IllegalArgumentException e) {
            throw new XMLParseException(e.getMessage(), e).setSource(this.source, start);
        }
    }

    protected void parseEntity(Token token) {
        char c;
        token.setType(Type.ENTITY);
        if (this.pos < this.source.length() && (c = this.source.charAt(this.pos)) == '#') {
            ++this.pos;
        }
        while (this.pos < this.source.length() && (c = this.source.charAt(this.pos)) != ';') {
            if (!this.charValidator.isNameChar(c)) {
                throw new XMLParseException("Illegal character in entity: [" + c + "] (" + Integer.toHexString(c) + ")", this.source, this.pos);
            }
            ++this.pos;
        }
        this.expect(';');
        this.verifyEntity(token.getStartOffset(), this.pos);
    }

    protected void nextChars(String expected, int startPos, String errorMessage) {
        int len = expected.length() - (this.pos - startPos);
        if (this.pos + len > this.source.length()) {
            throw new XMLParseException(errorMessage, this.source, startPos);
        }
        String s = this.source.substring(startPos, startPos + expected.length());
        if (!expected.equals(s)) {
            throw new XMLParseException(errorMessage, this.source, startPos);
        }
        this.pos += len;
    }

    protected char nextChar(String errorMessage) {
        if (this.pos >= this.source.length()) {
            throw new XMLParseException(errorMessage, this.source, this.pos);
        }
        return this.source.charAt(this.pos++);
    }

    protected void expect(char expected) {
        if (this.pos >= this.source.length() || this.source.charAt(this.pos) != expected) {
            throw new XMLParseException("Expected '" + expected + "'" + this.lookAheadForErrorMessage("but found", this.pos, 20), this.source, this.pos);
        }
        ++this.pos;
    }

    protected String lookAheadForErrorMessage(String conditionalPrefix, int pos, int len) {
        String found = "";
        if (pos < this.source.length()) {
            int len2 = this.source.length() - pos;
            len = Math.min(len, len2);
            String s = this.source.substring(pos, pos + len);
            if (len != len2) {
                s = s + "...";
            }
            found = conditionalPrefix == null ? TextUtils.escapeJavaString(s) : " " + conditionalPrefix + " " + TextUtils.escapeJavaString(s);
        }
        return found;
    }

    protected void skipWhiteSpace() {
        while (this.pos < this.source.length() && this.charValidator.isWhitespace(this.source.charAt(this.pos))) {
            ++this.pos;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        TEXT,
        CDATA,
        DTD_WHITESPACE,
        PROCESSING_INSTRUCTION,
        COMMENT,
        BEGIN_ELEMENT,
        ATTRIBUTE,
        CUSTOM_ATTRIBUTE,
        BEGIN_ELEMENT_END,
        END_ELEMENT,
        DOCUMENT,
        ELEMENT,
        CUSTOM_ELEMENT,
        ENTITY,
        DOCTYPE,
        DOCTYPE_SYSTEM,
        DOCTYPE_PUBLIC,
        DOCTYPE_NDATA,
        DOCTYPE_ELEMENT,
        DOCTYPE_ATTLIST,
        DOCTYPE_ENTITY,
        DOCTYPE_NOTATION,
        DOCTYPE_QUOTED_TEXT,
        DOCTYPE_BEGIN_SUBSET,
        DOCTYPE_END_SUBSET,
        DOCTYPE_END,
        DOCTYPE_COMMENT,
        DOCTYPE_BEGIN_GROUP,
        DOCTYPE_END_GROUP,
        DOCTYPE_ALTERNATIVE,
        DOCTYPE_ZERO_OR_ONE,
        DOCTYPE_ZERO_OR_MORE,
        DOCTYPE_ONE_OR_MORE,
        DOCTYPE_PARAMETER_ENTITY,
        DOCTYPE_PARAMETER_ENTITY_END,
        DOCTYPE_PCDATA,
        DOCTYPE_IMPLIED,
        DOCTYPE_REQUIRED,
        DOCTYPE_FIXED,
        DOCTYPE_SEQUENCE,
        DOCTYPE_CDATA;

    }
}

