/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.common.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlNamespaceFinder
extends DefaultHandler {
    private Set<String> namespaces = new HashSet<String>();
    private boolean namespaceFound = false;
    private SAXParserFactory factory;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (!this.namespaceFound && uri != null && uri.length() > 0) {
            this.namespaces.add(uri);
        }
    }

    public Set<String> getNamespaces() {
        return this.namespaces;
    }

    public SAXParserFactory getFactory() {
        return this.factory;
    }

    public void setFactory(SAXParserFactory factory) {
        this.factory = factory;
    }

    public Set<String> parseContents(InputSource contents) throws IOException, ParserConfigurationException, SAXException {
        this.namespaces.clear();
        if (this.factory == null) {
            this.factory = SAXParserFactory.newInstance();
        }
        if (this.factory != null) {
            SAXParser parser = this.createParser(this.factory);
            contents.setSystemId("/");
            parser.parse(contents, (DefaultHandler)this);
        }
        return this.namespaces;
    }

    protected final SAXParser createParser(SAXParserFactory parserFactory) throws ParserConfigurationException, SAXException {
        parserFactory.setNamespaceAware(true);
        SAXParser parser = parserFactory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        try {
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXNotSupportedException e) {
            // empty catch block
        }
        return parser;
    }
}

