/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.common.util.json;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;

public class JsonWriter {
    private JsonWriter() {
    }

    public static void write(OutputStream stream, Object value) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(stream);
        JsonWriter.write(writer, value);
        ((Writer)writer).flush();
    }

    public static void write(Writer writer, Object value) throws IOException {
        if (value instanceof Map) {
            JsonWriter.writeObject(writer, (Map)value);
        } else if (value instanceof Collection) {
            JsonWriter.writeArray(writer, (Collection)value);
        } else if (value instanceof Number) {
            JsonWriter.writeNumber(writer, (Number)value);
        } else if (value instanceof String) {
            JsonWriter.writeString(writer, (String)value);
        } else if (value instanceof Boolean) {
            JsonWriter.writeBoolean(writer, (Boolean)value);
        } else if (value == null) {
            JsonWriter.writeNull(writer);
        } else {
            throw new IllegalArgumentException("Unsupported value: " + value);
        }
    }

    private static void writeObject(Writer writer, Map<?, ?> value) throws IOException {
        writer.append('{');
        boolean first = true;
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            if (!first) {
                writer.append(',');
            } else {
                first = false;
            }
            JsonWriter.writeString(writer, (String)entry.getKey());
            writer.append(':');
            JsonWriter.write(writer, entry.getValue());
        }
        writer.append('}');
    }

    private static void writeString(Writer writer, String value) throws IOException {
        writer.append('\"');
        block3: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\"': 
                case '\\': {
                    writer.append('\\');
                    writer.append(c);
                    continue block3;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String s = Integer.toHexString(c);
                        writer.append('\\');
                        writer.append('u');
                        for (int j = s.length(); j < 4; ++j) {
                            writer.append('0');
                        }
                        writer.append(s);
                        continue block3;
                    }
                    writer.append(c);
                }
            }
        }
        writer.append('\"');
    }

    private static void writeNumber(Writer writer, Number value) throws IOException {
        writer.append(value.toString());
    }

    private static void writeBoolean(Writer writer, Boolean value) throws IOException {
        writer.append(Boolean.toString(value));
    }

    private static void writeArray(Writer writer, Collection<?> value) throws IOException {
        writer.append('[');
        boolean first = true;
        for (Object obj : value) {
            if (!first) {
                writer.append(',');
            } else {
                first = false;
            }
            JsonWriter.write(writer, obj);
        }
        writer.append(']');
    }

    private static void writeNull(Writer writer) throws IOException {
        writer.append("null");
    }
}

