/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.common.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownTracker {
    private static final transient Logger LOG = LoggerFactory.getLogger(ShutdownTracker.class);
    public static final boolean DISABLED = Boolean.getBoolean("io.fabric8.common.util.ShutdownTracker.DISABLED");
    private AtomicInteger retained = new AtomicInteger(1);
    private AtomicBoolean stopping = new AtomicBoolean(false);
    private Runnable onStopCallback;

    public void retain() {
        if (!this.attemptRetain()) {
            if (!DISABLED) {
                throw new ShutdownException();
            }
            LOG.info("Ignoring: retain() failure, would have caused a ShutdownException");
        }
    }

    public boolean attemptRetain() {
        LOG.trace("{} Trying to retain... retained:{}, stopping:{}", new Object[]{this, this.retained.get(), this.stopping.get()});
        if (this.retained.getAndIncrement() == 0 || this.stopping.get()) {
            this.retained.getAndDecrement();
            LOG.trace("{} Retain failed. retained:{}, stopping:{}", new Object[]{this, this.retained.get(), this.stopping.get()});
            return false;
        }
        LOG.trace("{} Retain succeded. retained:{}, stopping:{}", new Object[]{this, this.retained.get(), this.stopping.get()});
        return true;
    }

    public void release() {
        LOG.trace("{} Release notified. retained:{}, stopping:{}", new Object[]{this, this.retained.get(), this.stopping.get()});
        if (this.retained.decrementAndGet() == 0) {
            LOG.trace("{} All holders have released. retained:{}, stopping:{}", new Object[]{this, this.retained.get(), this.stopping.get()});
            if (!this.stopping.get()) {
                if (!DISABLED) {
                    this.retained.set(0);
                    throw new IllegalStateException("Unbalanced calls to release detected.");
                }
                LOG.info("Ignoring: release() failure, would have caused an IllegalStateException");
            } else if (this.onStopCallback != null) {
                LOG.trace("{} Invoking release callbacks. retained:{}, stopping:{}", new Object[]{this, this.retained.get(), this.stopping.get()});
                this.onStopCallback.run();
                this.onStopCallback = null;
                this.stopping.set(false);
                LOG.trace("{} Completely released. retained:{}, stopping:{}", new Object[]{this, this.retained.get(), this.stopping.get()});
            } else {
                this.stopping.set(false);
                LOG.trace("{} Completely released without a callback. retained:{}, stopping:{}", new Object[]{this, this.retained.get(), this.stopping.get()});
            }
        } else {
            LOG.trace("{} Release accepted. retained:{}, stopping:{}", new Object[]{this, this.retained.get(), this.stopping.get()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T use(Callable<T> callable) throws Exception {
        this.retain();
        try {
            T t = callable.call();
            return t;
        }
        finally {
            this.release();
        }
    }

    public void shutdown(Runnable onStopCallback) throws ShutdownException {
        if (this.stopping.compareAndSet(false, true)) {
            LOG.trace("{} Resource in shutdown state.", (Object)this);
            this.onStopCallback = onStopCallback;
            this.release();
        } else {
            if (!DISABLED) {
                throw new ShutdownException();
            }
            LOG.info("Ignoring: shutdown() failure, would have caused a ShutdownException");
        }
    }

    public void stop() throws ShutdownException, InterruptedException {
        LOG.trace("ShutdownException.stop() called on resource {}.", (Object)this);
        final CountDownLatch latch = new CountDownLatch(1);
        this.shutdown(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        latch.await();
        LOG.trace("ShutdownException.stop() terminated on resource {}.", (Object)this);
    }

    public Object proxy(final Object target) {
        Class<?> targetClass = target.getClass();
        return Proxy.newProxyInstance(targetClass.getClassLoader(), targetClass.getInterfaces(), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                ShutdownTracker.this.retain();
                try {
                    Object object = method.invoke(target, args);
                    return object;
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
                finally {
                    ShutdownTracker.this.release();
                }
            }
        });
    }

    public StandardMBean mbeanProxy(Object target) throws NotCompliantMBeanException {
        Class<?> targetClass = target.getClass();
        String targetClassName = targetClass.getSimpleName();
        for (Class<?> clazz : targetClass.getInterfaces()) {
            if (!clazz.getSimpleName().equals(targetClassName + "MBean") && !clazz.getSimpleName().equals(targetClassName + "MXBean")) continue;
            return new StandardMBean(this.proxy(target), clazz);
        }
        throw new NotCompliantMBeanException();
    }

    public static class ShutdownException
    extends IllegalStateException {
    }
}

