/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.autoscale;

import io.fabric8.api.AutoScaleProfileStatus;
import io.fabric8.api.AutoScaleRequest;
import io.fabric8.api.AutoScaleStatus;
import io.fabric8.api.Container;
import io.fabric8.api.ContainerAutoScaler;
import io.fabric8.api.Containers;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.jcip.GuardedBy;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.autoscale.AutoScalerNode;
import io.fabric8.common.util.Closeables;
import io.fabric8.common.util.Strings;
import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.groups.NodeState;
import io.fabric8.groups.internal.ZooKeeperGroup;
import io.fabric8.internal.RequirementsJson;
import io.fabric8.internal.autoscale.AutoScalers;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperMasterCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.autoscale", label="Fabric8 auto scaler", immediate=true, policy=ConfigurationPolicy.OPTIONAL, metatype=true)
public final class AutoScaleController
extends AbstractComponent
implements GroupListener<AutoScalerNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoScaleController.class);
    @Reference(referenceInterface=CuratorFramework.class, bind="bindCurator", unbind="unbindCurator")
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=FabricService.class, bind="bindFabricService", unbind="unbindFabricService")
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Property(name="pollTime", longValue={10000L}, label="Poll period", description="The number of milliseconds between polls to check if the system still has its requirements satisfied.")
    private long pollTime = 10000L;
    private AtomicReference<Timer> timer = new AtomicReference();
    @GuardedBy(value="volatile")
    private volatile Group<AutoScalerNode> group;
    private Runnable runnable = new Runnable(){

        @Override
        public void run() {
            AutoScaleController.this.onConfigurationChanged();
        }
    };
    private ZooKeeperMasterCache zkMasterCache;

    @Activate
    void activate() {
        CuratorFramework curator = (CuratorFramework)this.curator.get();
        this.enableMasterZkCache(curator);
        this.group = new ZooKeeperGroup(curator, ZkPath.AUTO_SCALE_CLUSTER.getPath(new String[0]), AutoScalerNode.class);
        this.group.add((GroupListener)this);
        this.group.update((NodeState)this.createState());
        this.group.start();
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.disableMasterZkCache();
        this.disableTimer();
        this.deactivateComponent();
        this.group.remove((GroupListener)this);
        Closeables.closeQuietly(this.group);
        this.group = null;
    }

    public void groupEvent(Group<AutoScalerNode> group, GroupListener.GroupEvent event) {
        DataStore dataStore = (DataStore)((FabricService)this.fabricService.get()).adapt(DataStore.class);
        switch (event) {
            case CONNECTED: 
            case CHANGED: {
                if (this.isValid()) {
                    AutoScalerNode state = this.createState();
                    try {
                        if (group.isMaster()) {
                            this.enableMasterZkCache((CuratorFramework)this.curator.get());
                            LOGGER.info("AutoScaleController is the master");
                            group.update((NodeState)state);
                            dataStore.trackConfiguration(this.runnable);
                            this.enableTimer();
                            this.onConfigurationChanged();
                            break;
                        }
                        LOGGER.info("AutoScaleController is not the master");
                        group.update((NodeState)state);
                        this.disableTimer();
                        dataStore.untrackConfiguration(this.runnable);
                        this.disableMasterZkCache();
                    }
                    catch (IllegalStateException illegalStateException) {}
                    break;
                }
                LOGGER.info("Not valid with master: " + group.isMaster() + " fabric: " + this.fabricService.get() + " curator: " + this.curator.get());
                break;
            }
            case DISCONNECTED: {
                dataStore.untrackConfiguration(this.runnable);
            }
        }
    }

    protected void enableMasterZkCache(CuratorFramework curator) {
        this.zkMasterCache = new ZooKeeperMasterCache(curator);
    }

    protected void disableMasterZkCache() {
        if (this.zkMasterCache != null) {
            this.zkMasterCache = null;
        }
    }

    protected void enableTimer() {
        Timer newTimer = new Timer("fabric8-autoscaler");
        if (this.timer.compareAndSet(null, newTimer)) {
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    LOGGER.debug("autoscale timer");
                    AutoScaleController.this.autoScale();
                }
            };
            newTimer.schedule(timerTask, this.pollTime, this.pollTime);
        }
    }

    protected void disableTimer() {
        Timer oldValue = this.timer.getAndSet(null);
        if (oldValue != null) {
            oldValue.cancel();
        }
    }

    private void onConfigurationChanged() {
        LOGGER.debug("Configuration has changed; so checking the auto-scaling requirements");
        this.autoScale();
    }

    private void autoScale() {
        FabricService service = (FabricService)this.fabricService.get();
        FabricRequirements requirements = service.getRequirements();
        List profileRequirements = requirements.getProfileRequirements();
        if (profileRequirements != null && !profileRequirements.isEmpty()) {
            AutoScaleStatus status = new AutoScaleStatus();
            for (ProfileRequirements profileRequirement : profileRequirements) {
                ContainerAutoScaler autoScaler = this.createAutoScaler(requirements, profileRequirement);
                if (autoScaler != null) {
                    this.autoScaleProfile(service, autoScaler, requirements, profileRequirement, status);
                    continue;
                }
                LOGGER.warn("No ContainerAutoScaler available for profile " + profileRequirement.getProfile());
            }
            if (this.zkMasterCache != null) {
                try {
                    String json = RequirementsJson.toJSON((AutoScaleStatus)status);
                    String zkPath = ZkPath.AUTO_SCALE_STATUS.getPath(new String[0]);
                    this.zkMasterCache.setStringData(zkPath, json, CreateMode.EPHEMERAL);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to write autoscale status " + e, (Throwable)e);
                }
            } else {
                LOGGER.warn("No ZooKeeperMasterCache!");
            }
        }
    }

    private ContainerAutoScaler createAutoScaler(FabricRequirements requirements, ProfileRequirements profileRequirements) {
        FabricService service = (FabricService)this.fabricService.getOptional();
        if (service != null) {
            return service.createContainerAutoScaler(requirements, profileRequirements);
        }
        LOGGER.warn("No FabricService available so cannot autoscale");
        return null;
    }

    private void autoScaleProfile(FabricService service, final ContainerAutoScaler autoScaler, FabricRequirements requirements, ProfileRequirements profileRequirement, AutoScaleStatus status) {
        final String profile = profileRequirement.getProfile();
        Integer minimumInstances = profileRequirement.getMinimumInstances();
        Integer maximumInstances = profileRequirement.getMaximumInstances();
        if (maximumInstances != null || minimumInstances != null) {
            List containers;
            int count;
            int delta;
            if (maximumInstances != null && (delta = (count = (containers = Containers.aliveAndSuccessfulContainersForProfile((String)profile, (FabricService)service)).size()) - maximumInstances) > 0) {
                this.stopContainers(containers, autoScaler, requirements, profileRequirement, status, delta);
            }
            if (minimumInstances != null) {
                containers = Containers.aliveOrPendingContainersForProfile((String)profile, (FabricService)service);
                count = containers.size();
                delta = minimumInstances - count;
                try {
                    AutoScaleProfileStatus profileStatus = status.profileStatus(profile);
                    if (delta < 0) {
                        profileStatus.destroyingContainer();
                        autoScaler.destroyContainers(profile, -delta, containers);
                    } else if (delta > 0) {
                        if (AutoScalers.requirementsSatisfied((FabricService)service, (FabricRequirements)requirements, (ProfileRequirements)profileRequirement, (AutoScaleStatus)status)) {
                            profileStatus.creatingContainer();
                            String requirementsVersion = requirements.getVersion();
                            String version = Strings.isNotBlank((String)requirementsVersion) ? requirementsVersion : service.getDefaultVersionId();
                            final AutoScaleRequest command = new AutoScaleRequest(service, version, profile, delta, requirements, profileRequirement, status);
                            new Thread("Creating container for " + command.getProfile()){

                                @Override
                                public void run() {
                                    try {
                                        autoScaler.createContainers(command);
                                    }
                                    catch (Exception e) {
                                        LOGGER.error("Failed to create container of profile: " + profile + ". Caught: " + e, (Throwable)e);
                                    }
                                }
                            }.start();
                        }
                    } else {
                        profileStatus.provisioned();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to auto-scale " + profile + ". Caught: " + e, (Throwable)e);
                }
            }
        }
    }

    protected void stopContainers(List<Container> containers, ContainerAutoScaler autoScaler, FabricRequirements requirements, ProfileRequirements profileRequirement, AutoScaleStatus status, int delta) {
        String profile = profileRequirement.getProfile();
        AutoScaleProfileStatus profileStatus = status.profileStatus(profile);
        ArrayList<Container> sorted = new ArrayList<Container>(containers);
        Collections.reverse(sorted);
        ArrayList<String> stoppingContainerIds = new ArrayList<String>();
        for (int i = 0; i < delta && i < sorted.size(); ++i) {
            Container container = (Container)sorted.get(i);
            stoppingContainerIds.add(container.getId());
            profileStatus.stoppingContainers(stoppingContainerIds);
            container.stop(true);
        }
    }

    private AutoScalerNode createState() {
        AutoScalerNode state = new AutoScalerNode();
        return state;
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }
}

