/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camel.autotest;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.scr.AbstractFieldInjectionComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.utils.Strings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.camel.autotest", label="Fabric8 Camel Auto Test Service", description="Enabling this service will automatically send any sample test messages stored in the wiki for the CamelContext ID and route ID to the routes whenever the route is restarted (such as if you edit the route or change its source, configuration or code).", policy=ConfigurationPolicy.REQUIRE, immediate=true, metatype=true)
public final class CamelAutoTestService
extends AbstractFieldInjectionComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(CamelAutoTestService.class);
    @Reference(referenceInterface=FabricService.class, bind="bindFabricService", unbind="unbindFabricService")
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=MBeanServer.class, bind="bindMBeanServer", unbind="unbindMBeanServer")
    private MBeanServer mbeanServer;
    @Reference(referenceInterface=CamelContext.class, cardinality=ReferenceCardinality.MANDATORY_MULTIPLE, bind="bindCamelContexts", unbind="unbindCamelContexts")
    private Map<String, CamelContext> camelContexts = new HashMap<String, CamelContext>();
    @Property(name="mockOutputs", boolValue={true}, label="Mock output endpoints", description="If enabled then the output endpoints are replaced with mock endpoints for easier testing/viewing and the underlying middleware isn't used.")
    private boolean mockOutputs = true;
    @Property(name="mockInputs", boolValue={true}, label="Mock input endpoints", description="If enabled then the input endpoints on tested camel routes are stubbed out so the underlying middleware isn't used.")
    private boolean mockInputs = true;
    @Property(name="messageFolder", value={"testMessages"}, label="Test message folder", description="The folder path in the wiki to store sample input messages")
    private String messageFolder = "testMessages";
    private Set<String> camelContextsConfigured = new HashSet<String>();

    protected void onDeactivate() throws Exception {
        LOG.warn("onDeactivate");
        this.camelContextsConfigured.clear();
        super.onDeactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onConfigured() throws Exception {
        LOG.warn("onConfigured! mockOutputs: " + this.mockOutputs + " mockInputs: " + this.mockInputs + " messageFolder: " + this.messageFolder);
        FabricService fabricService = (FabricService)this.fabricService.getOptional();
        MBeanServer mbeanServerValue = this.mbeanServer;
        if (mbeanServerValue != null && fabricService != null) {
            Profile overlayProfile = fabricService.getCurrentContainer().getOverlayProfile();
            List configurationFileNames = overlayProfile.getConfigurationFileNames();
            for (CamelContext camelContext : this.camelContexts.values()) {
                String path;
                String camelContextID = camelContext.getName();
                if (!(camelContext instanceof ModelCamelContext)) continue;
                ModelCamelContext modelCamelContext = (ModelCamelContext)camelContext;
                List routeDefinitions = modelCamelContext.getRouteDefinitions();
                if (!this.camelContextsConfigured.add(camelContextID)) continue;
                NodeIdFactory nodeIdFactory = camelContext.getNodeIdFactory();
                if (this.mockInputs || this.mockOutputs) {
                    for (RouteDefinition routeDefinition : routeDefinitions) {
                        String routeId = routeDefinition.idOrCreate(nodeIdFactory);
                        modelCamelContext.stopRoute(routeId);
                        String routeKey = camelContextID + "." + routeId;
                        LOG.info("mocking camel route: " + routeKey);
                        routeDefinition.adviceWith(modelCamelContext, (RouteBuilder)new AdviceWithRouteBuilder(){

                            public void configure() throws Exception {
                                if (CamelAutoTestService.this.mockOutputs) {
                                    this.mockEndpoints();
                                }
                            }
                        });
                        modelCamelContext.removeRouteDefinition(routeDefinition);
                        modelCamelContext.addRouteDefinition(routeDefinition);
                        modelCamelContext.startRoute(routeId);
                    }
                }
                if (Strings.isNotBlank(path = this.messageFolder)) {
                    path = path + "/";
                }
                path = path + camelContextID;
                ProducerTemplate producerTemplate = camelContext.createProducerTemplate();
                try {
                    for (RouteDefinition routeDefinition : routeDefinitions) {
                        String routeId = routeDefinition.idOrCreate(nodeIdFactory);
                        String routePath = path + "/" + routeId + "/";
                        List inputs = routeDefinition.getInputs();
                        for (FromDefinition input : inputs) {
                            Endpoint endpoint = input.getEndpoint();
                            if (endpoint == null) {
                                String ref;
                                String uri = input.getUri();
                                if (Strings.isNullOrBlank(uri) && Strings.isNotBlank(ref = input.getRef())) {
                                    uri = "ref:" + ref;
                                }
                                if (Strings.isNotBlank(uri)) {
                                    endpoint = camelContext.getEndpoint(uri);
                                }
                            }
                            if (endpoint == null) {
                                LOG.warn("Cannot find endpoint, uri or ref of input " + input + " on route " + routeId + " camelContext: " + camelContextID);
                                continue;
                            }
                            for (String configFile : configurationFileNames) {
                                if (!configFile.startsWith(routePath)) continue;
                                LOG.info("Sending file: " + configFile + " to " + endpoint);
                                byte[] data = overlayProfile.getFileConfiguration(configFile);
                                if (data == null) continue;
                                producerTemplate.sendBody(endpoint, (Object)data);
                            }
                        }
                    }
                }
                finally {
                    producerTemplate.stop();
                }
            }
        }
    }

    FabricService getFabricService() {
        return (FabricService)this.fabricService.get();
    }

    void bindCamelContexts(CamelContext camelContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("bind camel context " + camelContext + " status: " + (camelContext == null ? "null" : camelContext.getStatus()));
        }
        String id = camelContext.getName();
        this.camelContexts.put(id, camelContext);
        this.clearCamelContextConfiguration(id);
    }

    protected void clearCamelContextConfiguration(String camelContextId) {
        this.camelContextsConfigured.remove(camelContextId);
    }

    void unbindCamelContexts(CamelContext camelContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("unbind camel context " + camelContext + " status: " + camelContext.getStatus());
        }
        String id = camelContext.getName();
        this.camelContexts.remove(id);
        this.clearCamelContextConfiguration(id);
    }

    void bindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    void unbindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = null;
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }
}

