/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camel.autotest;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.InterceptSendToEndpoint;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelAutoInterceptSendToEndpointStrategy
implements EndpointStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(CamelAutoInterceptSendToEndpointStrategy.class);
    private final String pattern;
    private boolean skip;

    public CamelAutoInterceptSendToEndpointStrategy() {
        this.pattern = null;
    }

    public Endpoint registerEndpoint(String uri, Endpoint endpoint) {
        if (endpoint instanceof InterceptSendToEndpoint) {
            return endpoint;
        }
        if (endpoint instanceof MockEndpoint) {
            return endpoint;
        }
        if (this.matchPattern(uri, endpoint, this.pattern)) {
            Producer producer;
            InterceptSendToEndpoint proxy = new InterceptSendToEndpoint(endpoint, this.skip);
            String key = "mock:" + endpoint.getEndpointKey().replaceFirst("://", ":");
            if (key.contains("?")) {
                key = ObjectHelper.before((String)key, (String)"?");
            }
            LOG.info("Adviced endpoint [" + uri + "] with mock endpoint [" + key + "]");
            MockEndpoint mock = (MockEndpoint)endpoint.getCamelContext().getEndpoint(key, MockEndpoint.class);
            try {
                producer = mock.createProducer();
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
            }
            producer = this.onInterceptEndpoint(uri, endpoint, mock, producer);
            proxy.setDetour((Processor)producer);
            return proxy;
        }
        return endpoint;
    }

    protected boolean matchPattern(String uri, Endpoint endpoint, String pattern) {
        return uri == null || pattern == null || EndpointHelper.matchEndpoint((CamelContext)endpoint.getCamelContext(), (String)uri, (String)pattern);
    }

    protected Producer onInterceptEndpoint(String uri, Endpoint endpoint, MockEndpoint mockEndpoint, Producer mockProducer) {
        CamelContext context = mockEndpoint.getCamelContext();
        try {
            Object me = context.getManagementStrategy().getManagementObjectStrategy().getManagedObjectForEndpoint(context, (Endpoint)mockEndpoint);
            if (me != null && !context.getManagementStrategy().isManaged(me, null)) {
                LOG.info("Registering mock endpoint in JMX: {}", (Object)mockEndpoint);
                context.getManagementStrategy().manageObject(me);
            }
        }
        catch (Exception e) {
            LOG.warn("Error registering mock endpoint in JMX: " + mockEndpoint + " due " + e.getMessage() + ". This exception is ignored.");
        }
        return mockProducer;
    }

    public String toString() {
        return "CamelAutoInterceptSendToEndpointStrategy";
    }
}

