/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camel;

import io.fabric8.camel.CamelNodeState;
import io.fabric8.camel.MasterComponent;
import io.fabric8.groups.Group;
import io.fabric8.groups.internal.ManagedGroupFactory;
import io.fabric8.groups.internal.ManagedGroupFactoryBuilder;
import java.util.concurrent.Callable;
import org.apache.camel.impl.DefaultComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.RetryOneTime;

public abstract class ZKComponentSupport
extends DefaultComponent
implements Callable<CuratorFramework>,
ConnectionStateListener {
    private static final transient Log LOG = LogFactory.getLog(MasterComponent.class);
    private static final String ZOOKEEPER_URL = "zookeeper.url";
    private static final String ZOOKEEPER_PASSWORD = "zookeeper.password";
    private static final String ZOOKEEPER_URL_ENV = "ZOOKEEPER_URL";
    private static final String ZOOKEEPER_HOST_ENV = "ZK_CLIENT_SERVICE_HOST";
    private static final String ZOOKEEPER_PORT_ENV = "ZK_CLIENT_SERVICE_PORT";
    private ManagedGroupFactory managedGroupFactory;
    private CuratorFramework curator;
    private boolean shouldCloseZkClient = false;
    private int maximumConnectionTimeout = 10000;
    private String zooKeeperUrl;
    private String zooKeeperPassword;

    public CuratorFramework getCurator() {
        if (this.managedGroupFactory == null) {
            throw new IllegalStateException("Component is not started");
        }
        return this.managedGroupFactory.getCurator();
    }

    public Group<CamelNodeState> createGroup(String path) {
        if (this.managedGroupFactory == null) {
            throw new IllegalStateException("Component is not started");
        }
        return this.managedGroupFactory.createGroup(path, CamelNodeState.class);
    }

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
        this.registerAsListener();
    }

    public boolean isShouldCloseZkClient() {
        return this.shouldCloseZkClient;
    }

    public void setShouldCloseZkClient(boolean shouldCloseZkClient) {
        this.shouldCloseZkClient = shouldCloseZkClient;
    }

    public int getMaximumConnectionTimeout() {
        return this.maximumConnectionTimeout;
    }

    public void setMaximumConnectionTimeout(int maximumConnectionTimeout) {
        this.maximumConnectionTimeout = maximumConnectionTimeout;
    }

    public String getZooKeeperUrl() {
        return this.zooKeeperUrl;
    }

    public void setZooKeeperUrl(String zooKeeperUrl) {
        this.zooKeeperUrl = zooKeeperUrl;
    }

    public String getZooKeeperPassword() {
        return this.zooKeeperPassword;
    }

    public void setZooKeeperPassword(String zooKeeperPassword) {
        this.zooKeeperPassword = zooKeeperPassword;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.curator == null) {
            try {
                CuratorFramework _curator = (CuratorFramework)this.getCamelContext().getRegistry().lookupByName("curator");
                this.setCurator(_curator);
                if (this.curator != null) {
                    LOG.debug((Object)("Zookeeper client found in camel registry. " + this.curator));
                }
            }
            catch (Exception exception) {
                LOG.warn((Object)exception);
            }
        }
        this.managedGroupFactory = ManagedGroupFactoryBuilder.create((CuratorFramework)this.curator, (ClassLoader)this.getClass().getClassLoader(), (Callable)this);
    }

    @Override
    public CuratorFramework call() throws Exception {
        String password;
        String zkHost;
        String connectString = this.getZooKeeperUrl();
        if (connectString == null) {
            connectString = System.getenv(ZOOKEEPER_URL_ENV);
        }
        if (connectString == null && (zkHost = System.getenv(ZOOKEEPER_HOST_ENV)) != null) {
            String zkPort = System.getenv(ZOOKEEPER_PORT_ENV);
            connectString = zkHost + ":" + (zkPort == null ? "2181" : zkPort);
        }
        if (connectString == null) {
            connectString = System.getProperty(ZOOKEEPER_URL, "localhost:2181");
        }
        if ((password = this.getZooKeeperPassword()) == null) {
            System.getProperty(ZOOKEEPER_PASSWORD);
        }
        LOG.debug((Object)("CuratorFramework not found in camel registry, creating new with connection " + connectString));
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(connectString).retryPolicy((RetryPolicy)new RetryOneTime(1000)).connectionTimeoutMs(this.getMaximumConnectionTimeout());
        if (password != null && !password.isEmpty()) {
            builder.authorization("digest", ("fabric:" + password).getBytes());
        }
        this.curator = builder.build();
        LOG.debug((Object)("Starting curator " + this.curator));
        this.curator.start();
        return this.curator;
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.managedGroupFactory != null) {
            this.managedGroupFactory.close();
            this.managedGroupFactory = null;
        }
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        LOG.info((Object)("Curator Connection new state: " + newState));
    }

    protected void registerAsListener() {
        if (this.curator != null) {
            this.curator.getConnectionStateListenable().addListener((Object)this);
        }
    }
}

