/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.commands.ContainerLifecycleCommand;
import io.fabric8.utils.FabricValidations;
import org.apache.felix.gogo.commands.Command;

@Command(name="container-stop", scope="fabric", description="Shut down an existing container", detailedDescription="classpath:containerStop.txt")
public class ContainerStop
extends ContainerLifecycleCommand {
    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        FabricValidations.validateContainersName(this.container);
        if (this.isPartOfEnsemble(this.container) && !this.force) {
            System.out.println("Container is part of the ensemble. If you still want to stop it, please use -f option.");
            return null;
        }
        Container found = this.getContainer(this.container);
        this.applyUpdatedCredentials(found);
        if (this.force || found.isAlive()) {
            found.stop(this.force);
        } else {
            System.err.println("Container " + this.container + " is already stopped");
        }
        return null;
    }
}

