/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import io.fabric8.utils.Closeables;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class Files {
    private static final int BUFFER_SIZE = 8192;

    public static File createTempFile() throws IOException {
        File dataDir = new File(System.getProperty("karaf.data"));
        File tmpDir = new File(dataDir, "tmp");
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            throw new IOException("Failed to create tmp dir:" + tmpDir.getAbsolutePath());
        }
        return File.createTempFile(String.valueOf(System.currentTimeMillis()), ".tmp", tmpDir);
    }

    public static String toString(File file, Charset charset) throws IOException {
        byte[] bytes = Files.readBytes(file);
        if (charset != null) {
            return new String(bytes, charset);
        }
        return new String(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        ArrayList<String> answer = new ArrayList<String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                answer.add(line);
            }
        }
        finally {
            reader.close();
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(File file, List<String> lines) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        try {
            for (String line : lines) {
                writer.println(line);
            }
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(File file) throws IOException {
        byte[] byArray;
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        if (file == null) {
            throw new FileNotFoundException("No file specified");
        }
        try {
            int remaining;
            fis = new FileInputStream(file);
            bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((remaining = fis.read(buffer)) > 0) {
                bos.write(buffer, 0, remaining);
            }
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            Closeables.closeQuitely(fis);
            Closeables.closeQuitely(bos);
            throw throwable;
        }
        Closeables.closeQuitely(fis);
        Closeables.closeQuitely(bos);
        return byArray;
    }

    public static String toString(File file) throws IOException {
        return Files.toString(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, String content, Charset charset) throws IOException {
        FileOutputStream fos = null;
        OutputStreamWriter writer = null;
        try {
            if (file == null) {
                throw new FileNotFoundException("No file specified.");
            }
            if (!(file.exists() || file.getParentFile().exists() || file.getParentFile().mkdirs())) {
                throw new FileNotFoundException("Could not find or create file:" + file.getName());
            }
            fos = new FileOutputStream(file);
            writer = new OutputStreamWriter((OutputStream)fos, charset);
            writer.write(content, 0, content.length());
            writer.flush();
        }
        catch (Throwable throwable) {
            Closeables.closeQuitely(fos);
            Closeables.closeQuitely(writer);
            throw throwable;
        }
        Closeables.closeQuitely(fos);
        Closeables.closeQuitely(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, byte[] content) throws IOException {
        FileOutputStream fos = null;
        try {
            if (file == null) {
                throw new FileNotFoundException("No file specified.");
            }
            if (!(file.exists() || file.getParentFile().exists() || file.getParentFile().mkdirs())) {
                throw new FileNotFoundException("Could not find or create file:" + file.getName());
            }
            fos = new FileOutputStream(file);
            fos.write(content);
        }
        catch (Throwable throwable) {
            Closeables.closeQuitely(fos);
            throw throwable;
        }
        Closeables.closeQuitely(fos);
    }

    public static void copy(File source, File target) throws IOException {
        if (!source.exists()) {
            throw new FileNotFoundException("Source file not found:" + source.getAbsolutePath());
        }
        if (!(target.exists() || target.getParentFile().exists() || target.getParentFile().mkdirs())) {
            throw new IOException("Can't create target directory:" + target.getParentFile().getAbsolutePath());
        }
        FileInputStream is = new FileInputStream(source);
        FileOutputStream os = new FileOutputStream(target);
        Files.copy(is, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream is, OutputStream os) throws IOException {
        try {
            int len;
            byte[] buffer = new byte[8192];
            while ((len = is.read(buffer)) > 0) {
                os.write(buffer, 0, len);
            }
        }
        finally {
            Closeables.closeQuitely(is);
            Closeables.closeQuitely(os);
        }
    }

    public static String getRelativePath(File rootDir, File file) throws IOException {
        String rootPath = rootDir.getCanonicalPath();
        String fullPath = file.getCanonicalPath();
        if (fullPath.startsWith(rootPath)) {
            return fullPath.substring(rootPath.length());
        }
        return fullPath;
    }

    public static void assertExists(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(file + " does not exist");
        }
    }

    public static void assertFileExists(File file) {
        Files.assertExists(file);
        if (!file.isFile()) {
            throw new IllegalArgumentException(file + " is not a file!");
        }
    }

    public static void assertDirectoryExists(File file) {
        Files.assertExists(file);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " is not a directory!");
        }
    }
}

