/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.Profile;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.utils.FabricValidations;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;

@Command(name="container-add-profile", scope="fabric", description="Adds the specified profile to the container list of profiles.")
public class ContainerAddProfile
extends FabricCommand {
    @Argument(index=0, name="container", description="The container name", required=true, multiValued=false)
    private String container;
    @Argument(index=1, name="profiles", description="The profiles to add to the container.", required=true, multiValued=true)
    private List<String> profiles;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        FabricValidations.validateContainersName(this.container);
        FabricValidations.validateProfileName(this.profiles);
        Container cont = this.getContainer(this.container);
        Profile[] profs = this.getProfiles(cont.getVersion(), this.profiles);
        cont.addProfiles(profs);
        return null;
    }
}

