/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.api.ProfileService;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.utils.FabricValidations;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="profile-create", scope="fabric", description="Create a new profile with the specified name and version", detailedDescription="classpath:profileCreate.txt")
public class ProfileCreateAction
extends AbstractAction {
    @Option(name="--version", description="The profile version. Defaults to the current default version.")
    private String versionId;
    @Option(name="--parent", multiValued=true, required=false, description="Optionally specifies one or multiple parent profiles. To specify multiple parent profiles, use this flag multiple times on the command line. For example, --parent foo --parent bar.")
    private List<String> parents;
    @Argument(index=0)
    private String profileId;
    private final ProfileService profileService;
    private final FabricService fabricService;

    ProfileCreateAction(FabricService fabricService) {
        this.profileService = (ProfileService)fabricService.adapt(ProfileService.class);
        this.fabricService = fabricService;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    protected Object doExecute() throws Exception {
        try {
            FabricValidations.validateProfileName(this.profileId);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            return null;
        }
        if (this.versionId != null) {
            this.profileService.getRequiredVersion(this.versionId);
        } else {
            this.versionId = this.fabricService.getDefaultVersionId();
        }
        Profile[] parents = FabricCommand.getExistingProfiles((FabricService)this.fabricService, (String)this.versionId, this.parents);
        ProfileBuilder builder = ProfileBuilder.Factory.create((String)this.versionId, (String)this.profileId);
        for (Profile parent : parents) {
            builder.addParent(parent.getId());
        }
        this.profileService.createProfile(builder.getProfile());
        return null;
    }
}

