/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Version;
import io.fabric8.commands.support.CommandUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="version-info", scope="fabric", description="Displays information about a version")
public class VersionInfoAction
extends AbstractAction {
    static final String FORMAT = "%-30s %s";
    @Argument(index=0, name="version", description="The version name.", required=true, multiValued=false)
    private String versionId;
    private final ProfileService profileService;
    private final FabricService fabricService;
    private final DataStore dataStore;

    VersionInfoAction(FabricService fabricService) {
        this.profileService = (ProfileService)fabricService.adapt(ProfileService.class);
        this.dataStore = (DataStore)fabricService.adapt(DataStore.class);
        this.fabricService = fabricService;
    }

    protected Object doExecute() throws Exception {
        if (!this.profileService.hasVersion(this.versionId)) {
            System.out.println("Version " + this.versionId + " does not exists!");
            return null;
        }
        Version version = this.profileService.getRequiredVersion(this.versionId);
        String description = (String)version.getAttributes().get("description");
        String derivedFrom = null;
        boolean defaultVersion = version.getId().equals(this.fabricService.getDefaultVersionId());
        List<Profile> profiles = CommandUtils.sortProfiles(version.getProfiles());
        ArrayList<Container> containerList = new ArrayList<Container>();
        for (String c : this.dataStore.getContainers()) {
            Container container = this.fabricService.getContainer(c);
            if (!version.getId().equals(container.getVersion().getId())) continue;
            containerList.add(container);
        }
        Container[] containers = CommandUtils.sortContainers(containerList.toArray(new Container[containerList.size()]));
        System.out.println(String.format(FORMAT, "Name:", version.getId()));
        System.out.println(String.format(FORMAT, "Description:", description != null ? description : ""));
        System.out.println(String.format(FORMAT, "Derived From:", derivedFrom != null ? derivedFrom : ""));
        System.out.println(String.format(FORMAT, "Default Version:", defaultVersion));
        if (containers.length == 0) {
            System.out.println(String.format(FORMAT, "Containers:", ""));
        } else {
            for (int i = 0; i < containers.length; ++i) {
                if (i == 0) {
                    System.out.println(String.format(FORMAT, "Containers (" + containers.length + "):", containers[i].getId()));
                    continue;
                }
                System.out.println(String.format(FORMAT, "", containers[i].getId()));
            }
        }
        if (profiles.size() == 0) {
            System.out.println(String.format(FORMAT, "Profiles:", ""));
        } else {
            for (int i = 0; i < profiles.size(); ++i) {
                if (i == 0) {
                    System.out.println(String.format(FORMAT, "Profiles (" + profiles.size() + "):", profiles.get(i).getId()));
                    continue;
                }
                System.out.println(String.format(FORMAT, "", profiles.get(i).getId()));
            }
        }
        return null;
    }
}

