/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.FabricAuthenticationException;
import io.fabric8.api.FabricService;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.core.jmx.FabricManager;
import io.fabric8.service.FabricServiceImpl;
import io.fabric8.utils.FabricValidations;
import io.fabric8.utils.shell.ShellUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="container-edit-jvm-options", scope="fabric", description="Get or set the configured JVM options for a specific container")
public class ContainerEditJvmOptionsAction
extends AbstractAction {
    public static final String KARAF_ADMIN_OBJECT_NAME = "org.apache.karaf:type=admin,name=%s";
    public static final String FABRIC_OBJECT_NAME = "io.fabric8:type=Fabric";
    public static final String JAVA_LANG_OBJECT_NAME = "java.lang:type=Runtime";
    public static final String OPERATION_CHILD = "changeJavaOpts";
    public static final String OPERATION_SSH = "changeCreateOptionsField";
    @Argument(index=0, name="containerName", description="The name of the container.", required=true, multiValued=false)
    private String container;
    @Argument(index=1, name="jvmOptions", description="The default JVM options to use, or empty to show current.", required=false, multiValued=false)
    private String jvmOptions;
    @Option(name="-u", aliases={"--username"}, description="Remote user name", required=false, multiValued=false)
    private String username;
    @Option(name="-p", aliases={"--password"}, description="Remote user password", required=false, multiValued=false)
    private String password;
    @Option(name="-f", aliases={"--full"}, description="Shows the full set of jvm params, included those specified at script level", required=false, multiValued=false)
    private boolean full = false;
    private final FabricServiceImpl fabricService;

    ContainerEditJvmOptionsAction(FabricService fabricService) {
        if (!(fabricService instanceof FabricServiceImpl)) {
            throw new IllegalArgumentException("FabricService instance should be of specialized typed FabricServiceImpl");
        }
        this.fabricService = (FabricServiceImpl)fabricService;
    }

    protected Object doExecute() throws Exception {
        FabricValidations.validateContainerName(this.container);
        if (!FabricCommand.doesContainerExist((FabricService)this.fabricService, (String)this.container)) {
            System.out.println("Container " + this.container + " does not exists!");
            return null;
        }
        Container containerInstance = FabricCommand.getContainerIfExists((FabricService)this.fabricService, (String)this.container);
        String type = containerInstance.getType();
        if (!"karaf".equals(type)) {
            System.out.println("Sorry, currently only \"karaf\" type container are supported");
            return null;
        }
        FabricManager fabricManager = new FabricManager(this.fabricService);
        if (this.full) {
            String jmxUrl = null;
            JMXConnector connector = null;
            MBeanServerConnection remote = null;
            HashMap<String, String[]> authenticationData = null;
            jmxUrl = containerInstance.getJmxUrl();
            authenticationData = this.prepareAuthenticationData();
            try {
                connector = this.connectOrRetry(authenticationData, jmxUrl);
            }
            catch (Exception e) {
                this.username = null;
                this.password = null;
                System.out.println("Operation Failed. Check logs.");
                this.log.error("Unable to connect to JMX Server", (Throwable)e);
                return null;
            }
            ObjectName objName = new ObjectName(JAVA_LANG_OBJECT_NAME);
            try {
                remote = connector.getMBeanServerConnection();
                Object[] arguments = (String[])remote.getAttribute(objName, "InputArguments");
                String output = Arrays.toString(arguments);
                output = output.replaceAll(",", "");
                output = output.substring(1, output.length() - 1);
                System.out.println(output);
            }
            catch (Exception e) {
                System.out.println("Operation Failed. Check logs.");
                this.log.error("Unable to fetch child jvm opts", (Throwable)e);
            }
            try {
                connector.close();
            }
            catch (IOException e) {
                this.log.error("Errors closing remote MBean connection", (Throwable)e);
            }
        } else {
            try {
                String output = fabricManager.getJvmOpts(this.container);
                if ("Inapplicable".equals(output)) {
                    String message = this.container + " jvmOpts cannot be handled within Fabric. You have to set required values directly in startup scripts.";
                    System.out.println(message);
                    this.log.error(message);
                    return null;
                }
                if (this.jvmOptions == null) {
                    System.out.println(output);
                } else {
                    fabricManager.setJvmOpts(this.container, this.jvmOptions);
                    System.out.println("Operation succeeded. New JVM flags will be loaded at the next start of " + this.container + " container");
                    this.log.info("Updated JVM flags for container {}", (Object)this.container);
                }
            }
            catch (Exception e) {
                System.out.println("Operation Failed. Check logs.");
                this.log.error("Unable to set ssh jvm opts", (Throwable)e);
            }
        }
        return null;
    }

    private HashMap<String, String[]> prepareAuthenticationData() {
        this.username = this.username != null && !this.username.isEmpty() ? this.username : ShellUtils.retrieveFabricUser(this.session);
        this.password = this.password != null ? this.password : ShellUtils.retrieveFabricUserPassword(this.session);
        String[] credentials = new String[]{this.username, this.password};
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        env.put("jmx.remote.credentials", credentials);
        return env;
    }

    private JMXConnector connectOrRetry(HashMap<String, String[]> env, String jmxUrl) throws IOException {
        JMXServiceURL target = new JMXServiceURL(jmxUrl);
        JMXConnector connector = null;
        try {
            connector = JMXConnectorFactory.connect(target, env);
        }
        catch (FabricAuthenticationException | SecurityException ex) {
            this.username = null;
            this.password = null;
            this.promptForJmxCredentialsIfNeeded();
            connector = JMXConnectorFactory.connect(target, env);
        }
        return connector;
    }

    private void promptForJmxCredentialsIfNeeded() throws IOException {
        if (this.username == null || this.username.isEmpty()) {
            this.log.debug("Prompting user for JMX login");
            this.username = ShellUtils.readLine(this.session, "JMX Login for " + this.container + ": ", false);
        }
        if (this.password == null) {
            this.password = ShellUtils.readLine(this.session, "JMX Password for " + this.username + "@" + this.container + ": ", true);
        }
    }
}

