/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.internal.RequirementsJson;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="requirements-import", scope="fabric", description="Imports the profile scaling requirements from a JSON configuration file")
public class RequirementsImportAction
extends AbstractAction {
    @Argument(index=0, required=true, description="Requirements JSON URL")
    protected String jsonUrl;
    private final FabricService fabricService;

    RequirementsImportAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    protected Object doExecute() throws Exception {
        InputStream is;
        File file = new File(this.jsonUrl);
        if (file.exists()) {
            if (file.isDirectory()) {
                System.out.println("The file " + this.jsonUrl + " is a directory!");
                return null;
            }
            is = new FileInputStream(this.jsonUrl);
        } else {
            is = new URL(this.jsonUrl).openStream();
        }
        if (is == null) {
            System.out.println("Could not open the URL " + this.jsonUrl);
            return null;
        }
        FabricRequirements requirements = RequirementsJson.readRequirements((InputStream)is);
        if (requirements != null) {
            this.getFabricService().setRequirements(requirements);
            System.out.println("Imported the fabric requirements from " + this.jsonUrl);
        }
        return null;
    }
}

