/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.CreateEnsembleOptions;
import io.fabric8.api.ServiceProxy;
import io.fabric8.api.ZooKeeperClusterService;
import io.fabric8.boot.commands.support.EnsembleCommandSupport;
import io.fabric8.common.util.Strings;
import io.fabric8.utils.FabricValidations;
import io.fabric8.zookeeper.bootstrap.BootstrapConfiguration;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.AbstractAction;
import org.osgi.framework.BundleContext;

@Command(name="ensemble-add", scope="fabric", description="Extend the current fabric ensemble by converting the specified containers into ensemble servers", detailedDescription="classpath:ensembleAdd.txt")
public class EnsembleAddAction
extends AbstractAction {
    @Option(name="--generate-zookeeper-password", multiValued=false, description="Flag to enable automatic generation of password")
    private boolean generateZookeeperPassword = false;
    @Option(name="--new-zookeeper-password", multiValued=false, description="The ensemble new password to use (defaults to the old one)")
    private String zookeeperPassword;
    @Option(name="--zookeeper-ticktime", multiValued=false, description="The length of a single tick, which is the basic time unit used by ZooKeeper, as measured in milliseconds. It is used to regulate heartbeats, and timeouts. For example, the minimum session timeout will be two ticks")
    private int zooKeeperTickTime;
    @Option(name="--zookeeper-init-limit", multiValued=false, description="The amount of time, in ticks (see tickTime), to allow followers to connect and sync to a leader")
    private int zooKeeperInitLimit;
    @Option(name="--zookeeper-sync-limit", multiValued=false, description="The amount of time, in ticks (see tickTime), to allow followers to sync with ZooKeeper")
    private int zooKeeperSyncLimit;
    @Option(name="--zookeeper-data-dir", multiValued=false, description="The location where ZooKeeper will store the in-memory database snapshots and, unless specified otherwise, the transaction log of updates to the database.")
    private String zooKeeperDataDir;
    @Option(name="-f", aliases={"--force"}, multiValued=false, description="Flag to force the addition without prompt")
    private boolean force = false;
    @Option(name="--migration-timeout", multiValued=false, description="Timeout to wait for containers to migrate to the new ensemble")
    private long migrationTimeout = 120000L;
    @Argument(required=true, multiValued=true, description="List of containers to be added")
    private List<String> containers;
    private final BundleContext bundleContext;
    private final ZooKeeperClusterService clusterService;
    private final BootstrapConfiguration bootstrapConfiguration;

    EnsembleAddAction(BundleContext bundleContext, ZooKeeperClusterService clusterService, BootstrapConfiguration bootstrapConfiguration) {
        this.bundleContext = bundleContext;
        this.clusterService = clusterService;
        this.bootstrapConfiguration = bootstrapConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        FabricValidations.validateContainerNames(this.containers);
        if (EnsembleCommandSupport.checkIfShouldModify((CommandSession)this.session, (boolean)this.force) && this.containers != null && !this.containers.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Adding containers:");
            for (String container : this.containers) {
                sb.append(" ").append(container);
            }
            sb.append(" to the ensemble. This may take a while.");
            CreateEnsembleOptions.Builder builder = CreateEnsembleOptions.builder();
            this.applyEnsembleConfiguration();
            builder = builder.zooKeeperServerTickTime(this.zooKeeperTickTime).zooKeeperServerInitLimit(this.zooKeeperInitLimit).zooKeeperServerSyncLimit(this.zooKeeperSyncLimit).zooKeeperServerDataDir(this.zooKeeperDataDir).migrationTimeout(this.migrationTimeout);
            builder.minimumPort(this.bootstrapConfiguration.getBootstrapOptions().getMinimumPort());
            builder.maximumPort(this.bootstrapConfiguration.getBootstrapOptions().getMaximumPort());
            if (!this.generateZookeeperPassword) {
                builder = this.zookeeperPassword == null || this.zookeeperPassword.isEmpty() ? builder.zookeeperPassword(this.clusterService.getZookeeperPassword()) : builder.zookeeperPassword(this.zookeeperPassword);
            }
            this.clusterService.addToCluster(this.containers, builder.build());
            try (ServiceProxy serviceProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, ZooKeeperClusterService.class);){
                System.out.println("Updated Zookeeper connection string: " + ((ZooKeeperClusterService)serviceProxy.getService()).getZooKeeperUrl());
            }
        }
        return null;
    }

    private void applyEnsembleConfiguration() throws Exception {
        String currentDataDir;
        Map currentConfig = this.clusterService.getEnsembleConfiguration();
        int currentTickTime = Integer.parseInt((String)currentConfig.get("tickTime"));
        int currentInitLimit = Integer.parseInt((String)currentConfig.get("initLimit"));
        int currentSyncLimit = Integer.parseInt((String)currentConfig.get("syncLimit"));
        int lastIndexOfFwdSlash = (currentDataDir = (String)currentConfig.get("dataDir")).lastIndexOf("/");
        currentDataDir = currentDataDir.substring(0, lastIndexOfFwdSlash < 0 ? currentDataDir.lastIndexOf("\\") : lastIndexOfFwdSlash);
        this.zooKeeperTickTime = this.zooKeeperTickTime != 0 ? this.zooKeeperTickTime : currentTickTime;
        this.zooKeeperInitLimit = this.zooKeeperInitLimit != 0 ? this.zooKeeperInitLimit : currentInitLimit;
        this.zooKeeperSyncLimit = this.zooKeeperSyncLimit != 0 ? this.zooKeeperSyncLimit : currentSyncLimit;
        this.zooKeeperDataDir = !Strings.isNullOrBlank((String)this.zooKeeperDataDir) ? this.zooKeeperDataDir : currentDataDir;
    }
}

