/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.util.tracker.ServiceTracker;

public class OsgiUtils {
    public static final Long SERVICE_TIMEOUT = 20000L;

    public void waitForSerice(Class type, long timeout) {
        OsgiUtils.waitForSerice(type, null, timeout);
    }

    public static void waitForSerice(Class type) {
        OsgiUtils.waitForSerice(type, null, SERVICE_TIMEOUT);
    }

    public static void waitForSerice(Class type, String filter, long timeout) {
        BundleContext bundleContext = OsgiUtils.getBundleContext();
        try (ServiceTracker tracker = null;){
            String flt = filter != null ? (filter.startsWith("(") ? "(&(objectClass=" + type.getName() + ")" + filter + ")" : "(&(objectClass=" + type.getName() + ")(" + filter + "))") : "(objectClass=" + type.getName() + ")";
            Filter osgiFilter = FrameworkUtil.createFilter((String)flt);
            tracker = new ServiceTracker(bundleContext, osgiFilter, null);
            tracker.open(true);
            if (tracker.waitForService(timeout) == null) {
                throw new RuntimeException("Gave up waiting for service " + flt);
            }
        }
    }

    private static BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(OsgiUtils.class).getBundleContext();
    }

    private static String explode(Dictionary dictionary) {
        Enumeration keys = dictionary.keys();
        StringBuffer result = new StringBuffer();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            result.append(String.format("%s=%s", key, dictionary.get(key)));
            if (!keys.hasMoreElements()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    private static Collection<ServiceReference> asCollection(ServiceReference[] references) {
        return references != null ? Arrays.asList(references) : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateCmConfigurationAndWait(BundleContext bundleContext, final Configuration config, Dictionary<String, Object> properties, long timeout, TimeUnit unit) throws IOException, InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        ServiceRegistration registration = bundleContext.registerService(ConfigurationListener.class, (Object)new ConfigurationListener(){

            public void configurationEvent(ConfigurationEvent event) {
                if (event.getType() == 1 && event.getPid() != null && event.getPid().equals(config.getPid())) {
                    latch.countDown();
                }
            }
        }, null);
        config.update(properties);
        try {
            boolean bl = latch.await(timeout, unit);
            return bl;
        }
        finally {
            registration.unregister();
        }
    }
}

