/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.commands.AbstractContainerLifecycleAction;
import io.fabric8.utils.FabricValidations;
import java.util.Collection;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(name="container-delete", scope="fabric", description="Stops and deletes an existing container", detailedDescription="classpath:containerDelete.txt")
public class ContainerDeleteAction
extends AbstractContainerLifecycleAction {
    protected final RuntimeProperties runtimeProperties;
    @Option(name="-r", aliases={"--recursive"}, multiValued=false, required=false, description="Recursively stops and deletes all child containers")
    protected boolean recursive = false;

    ContainerDeleteAction(FabricService fabricService, RuntimeProperties runtimeProperties) {
        super(fabricService);
        this.runtimeProperties = runtimeProperties;
    }

    protected Object doExecute() throws Exception {
        Collection<String> expandedNames = super.expandGlobNames(this.containers);
        for (String containerName : expandedNames) {
            FabricValidations.validateContainerName(containerName);
            if (FabricCommand.isPartOfEnsemble((FabricService)this.fabricService, (String)containerName) && !this.force) {
                System.out.println("Container is part of the ensemble. If you still want to delete it, please use --force option.");
                return null;
            }
            String runtimeIdentity = this.runtimeProperties.getRuntimeIdentity();
            if (containerName.equals(runtimeIdentity) && !this.force) {
                System.out.println("You shouldn't delete current container. If you still want to delete it, please use --force option.");
                return null;
            }
            Container found = FabricCommand.getContainerIfExists((FabricService)this.fabricService, (String)containerName);
            if (found != null) {
                this.applyUpdatedCredentials(found);
                if (this.recursive || this.force) {
                    for (Container child : found.getChildren()) {
                        child.destroy(this.force);
                    }
                }
                found.destroy(this.force);
                continue;
            }
            if (!this.force) continue;
            ((DataStore)this.fabricService.adapt(DataStore.class)).deleteContainer(this.fabricService, containerName);
        }
        return null;
    }
}

