/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.ZooKeeperClusterService;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.boot.commands.support.AbstractCommandComponent;
import io.fabric8.commands.EnsembleAddAction;
import io.fabric8.commands.support.EnsembleAddCompleter;
import io.fabric8.zookeeper.bootstrap.BootstrapConfiguration;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.console.Completer;
import org.osgi.framework.BundleContext;

@Component(immediate=true)
@Service(value={Function.class, AbstractCommand.class})
@Properties(value={@Property(name="osgi.command.scope", value={"fabric"}), @Property(name="osgi.command.function", value={"ensemble-add"})})
public class EnsembleAdd
extends AbstractCommandComponent {
    public static final String SCOPE_VALUE = "fabric";
    public static final String FUNCTION_VALUE = "ensemble-add";
    public static final String DESCRIPTION = "Extend the current fabric ensemble by converting the specified containers into ensemble servers";
    @Reference(referenceInterface=ZooKeeperClusterService.class)
    private final ValidatingReference<ZooKeeperClusterService> clusterService = new ValidatingReference();
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=BootstrapConfiguration.class)
    private final ValidatingReference<BootstrapConfiguration> bootstrapConfiguration = new ValidatingReference();
    @Reference(referenceInterface=EnsembleAddCompleter.class, bind="bindContainerCompleter", unbind="unbindContainerCompleter")
    private EnsembleAddCompleter containerCompleter;
    private BundleContext bundleContext;

    @Activate
    void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public Action createNewAction() {
        this.assertValid();
        return new EnsembleAddAction(this.bundleContext, (ZooKeeperClusterService)this.clusterService.get(), (BootstrapConfiguration)this.bootstrapConfiguration.get(), (FabricService)this.fabricService.get());
    }

    void bindClusterService(ZooKeeperClusterService clusterService) {
        this.clusterService.bind((Object)clusterService);
    }

    void unbindClusterService(ZooKeeperClusterService clusterService) {
        this.clusterService.unbind((Object)clusterService);
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindContainerCompleter(EnsembleAddCompleter completer) {
        this.bindCompleter((Completer)completer);
    }

    void unbindContainerCompleter(EnsembleAddCompleter completer) {
        this.unbindCompleter((Completer)completer);
    }

    void bindBootstrapConfiguration(BootstrapConfiguration configuration) {
        this.bootstrapConfiguration.bind((Object)configuration);
    }

    void unbindBootstrapConfiguration(BootstrapConfiguration configuration) {
        this.bootstrapConfiguration.unbind((Object)configuration);
    }
}

