/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import com.google.common.base.Charsets;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Profiles;
import io.fabric8.api.Version;
import io.fabric8.utils.PasswordEncoder;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.curator.CuratorACLManager;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.retry.RetryOneTime;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;

@Command(name="ensemble-password", scope="fabric", description="Display or update the ensemble password", detailedDescription="classpath:ensemblePassword.txt")
public class EnsemblePasswordAction
extends AbstractAction {
    private final FabricService fabricService;
    @Argument(index=0, name="new-password", description="The new ensemble password.  If not supplied, the password is displayed.")
    private String newPassword;
    @Option(name="-c", aliases={"--commit"}, multiValued=false, required=false, description="Commits the password change.")
    protected boolean commit = false;

    EnsemblePasswordAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        if (!this.commit) {
            if (this.newPassword == null) {
                System.out.println(this.fabricService.getZookeeperPassword());
            } else {
                String zookeeperUrl = this.fabricService.getZookeeperUrl();
                String oldPassword = this.fabricService.getZookeeperPassword();
                System.out.println("Updating the password...");
                CuratorACLManager aclManager = new CuratorACLManager();
                curator.start();
                try (CuratorFramework curator = CuratorFrameworkFactory.builder().connectString(zookeeperUrl).retryPolicy((RetryPolicy)new RetryOneTime(500)).aclProvider((ACLProvider)aclManager).authorization("digest", ("fabric:" + oldPassword).getBytes()).sessionTimeoutMs(30000).build();){
                    String digestedIdPass = DigestAuthenticationProvider.generateDigest((String)("fabric:" + this.newPassword));
                    aclManager.registerAcl("/fabric", "auth::acdrw,world:anyone:,digest:" + digestedIdPass + ":acdrw");
                    aclManager.fixAcl(curator, "/fabric", true);
                    curator.setData().forPath(ZkPath.CONFIG_ENSEMBLE_PASSWORD.getPath(new String[0]), PasswordEncoder.encode(this.newPassword).getBytes(Charsets.UTF_8));
                }
                ProfileService profileService = (ProfileService)this.fabricService.adapt(ProfileService.class);
                for (String ver : profileService.getVersions()) {
                    Profile profile;
                    Version version = profileService.getVersion(ver);
                    if (version == null || (profile = version.getProfile("default")) == null) continue;
                    Profiles.refreshProfile((FabricService)this.fabricService, (Profile)profile);
                }
                System.out.println("");
                System.out.println("Password updated. Please wait a little while for the new password to");
                System.out.println("get delivered as a config update to all the fabric nodes. Once, the ");
                System.out.println("nodes all updated (nodes must be online), please run:");
                System.out.println("");
                System.out.println("  fabric:ensemble-password --commit ");
                System.out.println("");
            }
        } else {
            CuratorACLManager aclManager = new CuratorACLManager();
            curator.start();
            try (CuratorFramework curator = CuratorFrameworkFactory.builder().connectString(this.fabricService.getZookeeperUrl()).retryPolicy((RetryPolicy)new RetryOneTime(500)).aclProvider((ACLProvider)aclManager).authorization("digest", ("fabric:" + this.fabricService.getZookeeperPassword()).getBytes()).sessionTimeoutMs(30000).build();){
                aclManager.fixAcl(curator, "/fabric", true);
                System.out.println("Only the current password is allowed access to fabric now.");
            }
        }
        return null;
    }
}

