/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricService;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

public abstract class AbstractContainerLifecycleAction
extends AbstractAction {
    @Option(name="--user", description="The username to use.")
    protected String user;
    @Option(name="--password", description="The password to use.")
    protected String password;
    @Option(name="-f", aliases={"--force"}, multiValued=false, required=false, description="Force the execution of the command regardless of the known state of the container")
    protected boolean force = false;
    @Argument(index=0, name="container", description="The container names", required=true, multiValued=true)
    protected List<String> containers = null;
    protected final FabricService fabricService;
    protected final DataStore dataStore;

    protected AbstractContainerLifecycleAction(FabricService fabricService) {
        this.fabricService = fabricService;
        this.dataStore = (DataStore)fabricService.adapt(DataStore.class);
    }

    protected void applyUpdatedCredentials(Container container) {
        CreateContainerMetadata metadata;
        if ((this.user != null || this.password != null) && (metadata = container.getMetadata()) != null) {
            metadata.updateCredentials(this.user, this.password);
            this.dataStore.setContainerMetadata(container.getMetadata());
        }
    }

    protected List<String> matchedAvailableContainers(String pattern) {
        LinkedList<String> result = new LinkedList<String>();
        for (Container c : this.fabricService.getContainers()) {
            String name = c.getId();
            if (!this.matches(pattern, name)) continue;
            result.add(name);
        }
        return result;
    }

    protected boolean matches(String globPattern, String name) {
        String re = "^" + globPattern.replace(".", "\\.").replace("?", ".?").replace("*", ".*") + "$";
        return name.matches(re);
    }

    protected Collection<String> expandGlobNames(List<String> containerNames) {
        LinkedHashSet<String> expandedNames = new LinkedHashSet<String>();
        if (containerNames == null) {
            System.out.println("Please specify container name(s).");
            return expandedNames;
        }
        boolean globUsed = false;
        for (String name : containerNames) {
            if (name.contains("*") || name.contains("?")) {
                globUsed = true;
                expandedNames.addAll(this.matchedAvailableContainers(name));
                continue;
            }
            expandedNames.add(name);
        }
        if (expandedNames.size() == 0) {
            if (globUsed) {
                System.out.println("Please specify container name(s). Your pattern didn't match any container name.");
            } else {
                System.out.println("Please specify container name(s).");
            }
        } else {
            System.out.println("The list of container names: " + ((Object)expandedNames).toString());
        }
        return expandedNames;
    }
}

