/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Version;
import io.fabric8.commands.support.CommandUtils;
import io.fabric8.common.util.Strings;
import io.fabric8.utils.TablePrinter;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="profile-list", scope="fabric", description="Lists all profiles that belong to the specified version")
public class ProfileListAction
extends AbstractAction {
    @Option(name="--version", description="Specifies the version of the profiles to list. Defaults to the current default version.")
    private String versionId;
    @Option(name="--hidden", description="Display hidden profiles")
    private boolean hidden;
    private final FabricService fabricService;

    ProfileListAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    protected Object doExecute() throws Exception {
        ProfileService profileService = (ProfileService)this.fabricService.adapt(ProfileService.class);
        Version version = this.versionId != null ? profileService.getRequiredVersion(this.versionId) : this.fabricService.getRequiredDefaultVersion();
        List<Profile> profiles = version.getProfiles();
        profiles = CommandUtils.sortProfiles(profiles);
        this.printProfiles(profileService, profiles, System.out);
        return null;
    }

    protected void printProfiles(ProfileService profileService, List<Profile> profiles, PrintStream out) {
        TablePrinter table = new TablePrinter();
        table.columns("id", "# containers", "parents");
        for (Profile profile : profiles) {
            String profileId;
            String versionId = profile.getVersion();
            if (!profileService.hasProfile(versionId, profileId = profile.getId()) || !this.hidden && profile.isHidden()) continue;
            int active = this.fabricService.getAssociatedContainers(versionId, profileId).length;
            String parents = Strings.join((Collection)profile.getParentIds(), (String)" ");
            table.row(profileId, ProfileListAction.activeContainerCountText(active), parents);
        }
        table.print();
    }

    public static String activeContainerCountText(int active) {
        return active > 0 ? "" + active : "";
    }
}

