/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.FabricStatus;
import io.fabric8.api.ProfileStatus;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.Collection;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="status", scope="fabric", description="Displays the current status of the fabric by comparing the requirements to the actual instance counts", detailedDescription="classpath:status.txt")
public class StatusAction
extends AbstractAction {
    private final FabricService fabricService;

    StatusAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    protected Object doExecute() throws Exception {
        PrintStream out = System.out;
        FabricStatus status = this.getFabricService().getFabricStatus();
        this.printStatus(out, status);
        return null;
    }

    protected void printStatus(PrintStream out, FabricStatus status) {
        out.println(String.format("%-40s %-14s %s", "[profile]", "[instances]", "[health]"));
        Collection statuses = status.getProfileStatusMap().values();
        for (ProfileStatus profile : statuses) {
            String id = profile.getProfile();
            int instances = profile.getCount();
            double health = profile.getHealth(instances);
            out.println(String.format("%-40s %-14s %s", id, instances, this.percentText(health)));
        }
    }

    String percentText(double value) {
        return NumberFormat.getPercentInstance().format(value);
    }
}

