/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.commands.support.ChangeRequirementSupport;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(name="require-profile-set", scope="fabric", description="Sets the requirements of a profile in terms of its minimum and maximum required instances", detailedDescription="classpath:status.txt")
public class RequireProfileSetAction
extends ChangeRequirementSupport {
    @Option(name="--minimum", multiValued=false, required=false, description="The minimum number of instances expected of this profile in the fabric")
    protected Integer minimumInstances;
    @Option(name="--maximum", multiValued=false, required=false, description="The maximum number of instances expected of this profile in the fabric")
    protected Integer maximumInstances;
    @Option(name="--dependsOn", multiValued=true, required=false, description="The profile IDs which need to be provisioned before this profile. To specify multiple profiles, use this flag multiple times.")
    protected List<String> dependentProfiles;
    @Option(name="--version", multiValued=false, required=false, description="The version to operate onto. Defaults to the default version.")
    protected String v;
    @Argument(index=0, required=true, description="Profile ID")
    protected String profile;

    RequireProfileSetAction(FabricService fabricService) {
        super(fabricService);
    }

    @Override
    protected boolean updateRequirements(FabricRequirements requirements) {
        if (this.v != null) {
            this.setVersion(this.v);
        } else {
            this.setVersion(this.getFabricService().getDefaultVersionId());
        }
        ProfileRequirements requirement = new ProfileRequirements(this.profile);
        if (this.minimumInstances != null) {
            requirement.setMinimumInstances(this.minimumInstances);
        }
        if (this.maximumInstances != null) {
            requirement.setMaximumInstances(this.maximumInstances);
        }
        if (this.dependentProfiles != null) {
            requirement.setDependentProfiles(this.dependentProfiles);
        }
        requirements.addOrUpdateProfileRequirements(requirement);
        return true;
    }
}

