/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands.support;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class ContainerGlobSupport {
    public static Collection<String> expandGlobNames(FabricService fabricService, List<String> containerNames) {
        LinkedHashSet<String> expandedNames = new LinkedHashSet<String>();
        if (containerNames == null) {
            System.out.println("Please specify container name(s).");
            return expandedNames;
        }
        boolean globUsed = false;
        for (String name : containerNames) {
            if (name.contains("*") || name.contains("?")) {
                globUsed = true;
                expandedNames.addAll(ContainerGlobSupport.matchedAvailableContainers(fabricService, name));
                continue;
            }
            expandedNames.add(name);
        }
        if (expandedNames.size() == 0) {
            if (globUsed) {
                System.out.println("Please specify container name(s). Your pattern didn't match any container name.");
            } else {
                System.out.println("Please specify container name(s).");
            }
        } else {
            System.out.println("The list of container names: " + ((Object)expandedNames).toString());
        }
        return expandedNames;
    }

    public static List<String> matchedAvailableContainers(FabricService fabricService, String pattern) {
        LinkedList<String> result = new LinkedList<String>();
        for (Container c : fabricService.getContainers()) {
            String name = c.getId();
            if (!ContainerGlobSupport.matches(pattern, name)) continue;
            result.add(name);
        }
        return result;
    }

    public static boolean matches(String globPattern, String name) {
        String re = "^" + globPattern.replace(".", "\\.").replace("?", ".?").replace("*", ".*") + "$";
        return name.matches(re);
    }
}

