/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.commands.JMXRequest;
import io.fabric8.commands.support.JMXCommandActionSupport;
import java.util.Collection;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.queue.PublicStringSerializer;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.zookeeper.CreateMode;

@Command(name="git-synchronize", scope="fabric", description="Schedules synchronization of local git repositories for selected/all containers")
public class FabricGitSynchronizeAction
extends JMXCommandActionSupport {
    @Option(name="-p", aliases={"--allow-push"}, description="Whether containers are allowed to push local Git repository state to central Git repository", required=false, multiValued=false)
    protected boolean allowPush = false;
    @Option(name="-r", aliases={"--random-delay"}, description="Delay synchronization attempt by random number of seconds. By default each container will delay synchronization by 0-15 seconds to protect against too many pull operations.", required=false, multiValued=false)
    protected int randomDelay = 15;

    public FabricGitSynchronizeAction(FabricService fabricService, CuratorFramework curator, RuntimeProperties runtimeProperties) {
        super(fabricService, curator, runtimeProperties);
    }

    @Override
    protected void performContainerAction(String queuePath, String containerName) throws Exception {
        String command = this.map(new JMXRequest().withObjectName("io.fabric8:type=Fabric").withMethod("gitSynchronize").withDelay(this.randomDelay).withParam(Boolean.class, (Object)this.allowPush));
        ((ACLBackgroundPathAndBytesable)this.curator.create().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(queuePath, PublicStringSerializer.serialize((String)command));
    }

    @Override
    protected void afterEachContainer(Collection<String> names) {
        System.out.printf("Scheduled git-synchronize command to %d containers\n\n", names.size());
    }
}

