/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.commands.GitVersion;
import io.fabric8.api.commands.GitVersions;
import io.fabric8.api.commands.JMXRequest;
import io.fabric8.api.commands.JMXResult;
import io.fabric8.commands.support.JMXCommandActionSupport;
import io.fabric8.utils.TablePrinter;
import io.fabric8.zookeeper.ZkPath;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.queue.PublicStringSerializer;
import org.apache.felix.gogo.commands.Command;
import org.apache.zookeeper.CreateMode;

@Command(name="git-summary", scope="fabric", description="Retrieves status of git repository and its branches/versions")
public class FabricGitSummaryAction
extends JMXCommandActionSupport {
    private String master;
    private JMXRequest masterRequest;
    private JMXResult masterResult;
    private Map<String, JMXRequest> requests = new TreeMap<String, JMXRequest>();
    private Map<String, JMXResult> results = new TreeMap<String, JMXResult>();

    public FabricGitSummaryAction(FabricService fabricService, CuratorFramework curator, RuntimeProperties runtimeProperties) {
        super(fabricService, curator, runtimeProperties);
    }

    @Override
    protected void beforeEachContainer(Collection<String> names) throws Exception {
        this.master = this.fabricService.getGitMaster();
        if (this.master == null) {
            System.out.println("Can't find container which is current git master");
            return;
        }
        System.out.println("Git master is: " + this.master);
        String queuePath = ZkPath.COMMANDS_REQUESTS_QUEUE.getPath(new String[]{this.master});
        this.masterRequest = new JMXRequest().withObjectName("io.fabric8:type=GitServer").withMethod("gitVersions");
        String command = this.map(this.masterRequest);
        ((ACLBackgroundPathAndBytesable)this.curator.create().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(queuePath, PublicStringSerializer.serialize((String)command));
    }

    @Override
    protected void performContainerAction(String queuePath, String containerName) throws Exception {
        JMXRequest containerRequest = new JMXRequest().withObjectName("io.fabric8:type=Fabric").withMethod("gitVersions");
        this.requests.put(containerName, containerRequest);
        String command = this.map(containerRequest);
        ((ACLBackgroundPathAndBytesable)this.curator.create().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(queuePath, PublicStringSerializer.serialize((String)command));
    }

    @Override
    protected void afterEachContainer(Collection<String> names) {
        System.out.printf("Scheduled git-summary command to %d containers. Awaiting response(s).\n", names.size());
        final CountDownLatch latch = new CountDownLatch(this.requests.size() + (this.masterRequest == null ? 0 : 1));
        Thread waiter = null;
        try {
            waiter = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        String currentContainer = null;
                        try {
                            if (FabricGitSummaryAction.this.masterRequest != null && FabricGitSummaryAction.this.masterResult == null) {
                                currentContainer = FabricGitSummaryAction.this.master;
                                List results = FabricGitSummaryAction.this.fetchResponses(FabricGitSummaryAction.this.master);
                                for (JMXResult result : results) {
                                    if (!result.getCorrelationId().equals(FabricGitSummaryAction.this.masterRequest.getId())) continue;
                                    FabricGitSummaryAction.this.masterResult = result;
                                    latch.countDown();
                                    break;
                                }
                            }
                            block7: for (Map.Entry req : FabricGitSummaryAction.this.requests.entrySet()) {
                                currentContainer = (String)req.getKey();
                                List containerResults = FabricGitSummaryAction.this.fetchResponses(currentContainer);
                                for (JMXResult result : containerResults) {
                                    if (!result.getCorrelationId().equals(((JMXRequest)req.getValue()).getId())) continue;
                                    FabricGitSummaryAction.this.results.put(currentContainer, result);
                                    latch.countDown();
                                    continue block7;
                                }
                            }
                            if ((FabricGitSummaryAction.this.masterRequest == null || FabricGitSummaryAction.this.masterResult != null) && FabricGitSummaryAction.this.results.size() == FabricGitSummaryAction.this.requests.size()) break;
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        catch (Exception e) {
                            System.err.println("Problem occurred while fetching response from " + currentContainer + " container: " + e.getMessage());
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        break;
                    }
                }
            });
            waiter.start();
            boolean finished = latch.await(this.timeout, TimeUnit.MILLISECONDS);
            if (!finished) {
                waiter.interrupt();
                System.out.println("Timeout waiting for git-summary response");
                return;
            }
            HashMap<String, String> centralGitRepo = new HashMap<String, String>();
            TreeSet<String> outOfSyncContainers = new TreeSet<String>();
            if (this.masterResult != null) {
                for (GitVersion version : ((GitVersions)this.masterResult.getResponse()).getVersions()) {
                    centralGitRepo.put(version.getVersion(), version.getSha1());
                }
                for (String containerName : this.results.keySet()) {
                    List localRepo = ((GitVersions)this.results.get(containerName).getResponse()).getVersions();
                    for (GitVersion version : localRepo) {
                        String ref = (String)centralGitRepo.get(version.getVersion());
                        if (ref == null) {
                            outOfSyncContainers.add(containerName);
                            continue;
                        }
                        if (ref.equals(version.getSha1())) continue;
                        outOfSyncContainers.add(containerName);
                    }
                    if (localRepo.size() == centralGitRepo.size()) continue;
                    outOfSyncContainers.add(containerName);
                }
                if (outOfSyncContainers.size() > 0) {
                    System.out.println();
                    System.out.println("Containers that require synchronization: " + outOfSyncContainers);
                    System.out.println("Please use \"fabric:git-synchronize\" command");
                }
            } else {
                System.out.println();
                System.out.println("Can't determine synchronization status of containers - no master Git repository detected");
            }
            if (this.masterResult != null) {
                System.out.println();
                this.printVersions("=== Summary for master Git repository (container: " + this.master + ") ===", ((GitVersions)this.masterResult.getResponse()).getVersions());
            }
            System.out.println();
            for (String containerName : this.results.keySet()) {
                this.printVersions("=== Summary for local Git repository (container: " + containerName + ") ===", ((GitVersions)this.results.get(containerName).getResponse()).getVersions());
                System.out.println();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            waiter.interrupt();
            System.out.println("Interrupted waiting for git-summary response");
        }
    }

    private void printVersions(String title, List<GitVersion> versions) {
        System.out.println(title);
        TablePrinter table = new TablePrinter();
        table.columns("version", "SHA1", "timestamp", "message");
        for (GitVersion version : versions) {
            table.row(version.getVersion(), version.getSha1(), version.getTimestamp(), version.getMessage());
        }
        table.print();
    }

    private List<JMXResult> fetchResponses(String containerName) throws Exception {
        String path = ZkPath.COMMANDS_RESPONSES.getPath(new String[]{containerName});
        List responses = (List)this.curator.getChildren().forPath(path);
        return this.asResults(path, responses, GitVersions.class);
    }
}

