/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Version;
import io.fabric8.commands.support.CommandUtils;
import io.fabric8.utils.TablePrinter;
import java.io.PrintStream;
import java.util.List;
import java.util.Locale;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="container-list", scope="fabric", description="List the containers in the current fabric", detailedDescription="classpath:containerList.txt")
public class ContainerListAction
extends AbstractAction {
    @Option(name="--version", description="Optional version to use as filter")
    private String version;
    @Option(name="-v", aliases={"--verbose"}, description="Flag for verbose output", multiValued=false, required=false)
    private boolean verbose;
    @Argument(index=0, name="filter", description="Filter by container ID or by profile name. When a profile name is specified, only the containers with that profile are listed.", required=false, multiValued=false)
    private String filter = null;
    private final FabricService fabricService;
    private final ProfileService profileService;
    private final DataStore dataStore;
    private final Logger LOG = LoggerFactory.getLogger(ContainerListAction.class);

    ContainerListAction(FabricService fabricService) {
        this.fabricService = fabricService;
        this.profileService = (ProfileService)fabricService.adapt(ProfileService.class);
        this.dataStore = (DataStore)fabricService.adapt(DataStore.class);
    }

    protected Object doExecute() throws Exception {
        Container[] containers = this.fabricService.getContainers();
        containers = CommandUtils.filterContainers(containers, this.filter);
        containers = CommandUtils.sortContainers(containers);
        Version ver = null;
        if (this.version != null) {
            ver = this.profileService.getRequiredVersion(this.version);
        }
        if (this.verbose) {
            this.printContainersVerbose(containers, ver, System.out);
        } else {
            this.printContainers(containers, ver, System.out);
        }
        return null;
    }

    private void printContainers(Container[] containers, Version version, PrintStream out) {
        TablePrinter table = new TablePrinter();
        table.columns("id", "version", "type", "connected", "profiles", "provision status");
        for (Container container : containers) {
            if (!CommandUtils.matchVersion(container, version)) continue;
            String indent = "";
            Container c = container;
            while (!c.isRoot()) {
                indent = indent + "  ";
                c = c.getParent();
            }
            String marker = "";
            if (container.getId().equals(this.fabricService.getCurrentContainer().getId())) {
                marker = "*";
            }
            List assignedProfiles = this.dataStore.getContainerProfiles(container.getId());
            try {
                table.row(indent + container.getId() + marker, container.getVersionId(), container.getType(), ContainerListAction.aliveText(container), (String)assignedProfiles.get(0), CommandUtils.status(container));
            }
            catch (RuntimeException e) {
                this.LOG.warn("Problem getting the overlay profile for container " + container.getId(), (Throwable)e);
            }
            for (int i = 1; i < assignedProfiles.size(); ++i) {
                table.row("", "", "", "", (String)assignedProfiles.get(i), "");
            }
        }
        table.print();
    }

    protected static String aliveText(Container container) {
        return container.isAlive() ? "yes" : "no";
    }

    private void printContainersVerbose(Container[] containers, Version version, PrintStream out) {
        TablePrinter table = new TablePrinter();
        table.columns("id", "version", "type", "connected", "profiles", "blueprint", "spring", "provision status");
        for (Container container : containers) {
            if (!CommandUtils.matchVersion(container, version)) continue;
            String indent = "";
            Container c = container;
            while (!c.isRoot()) {
                indent = indent + "  ";
                c = c.getParent();
            }
            String marker = "";
            if (container.getId().equals(this.fabricService.getCurrentContainer().getId())) {
                marker = "*";
            }
            String blueprintStatus = this.dataStore.getContainerAttribute(container.getId(), DataStore.ContainerAttribute.BlueprintStatus, "", false, false);
            String springStatus = this.dataStore.getContainerAttribute(container.getId(), DataStore.ContainerAttribute.SpringStatus, "", false, false);
            blueprintStatus = blueprintStatus.toLowerCase(Locale.ENGLISH);
            springStatus = springStatus.toLowerCase(Locale.ENGLISH);
            List assignedProfiles = this.dataStore.getContainerProfiles(container.getId());
            table.row(indent + container.getId() + marker, container.getVersionId(), container.getType(), ContainerListAction.aliveText(container), (String)assignedProfiles.get(0), blueprintStatus, springStatus, CommandUtils.status(container));
            for (int i = 1; i < assignedProfiles.size(); ++i) {
                table.row("", "", "", "", (String)assignedProfiles.get(i), "", "", "");
            }
        }
        table.print();
    }
}

