/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileService;
import io.fabric8.api.ZooKeeperClusterService;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.boot.commands.support.AbstractCommandComponent;
import io.fabric8.commands.EnsembleSecurityAction;
import java.util.Map;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Function;

@Component(immediate=true)
@Service(value={Function.class, AbstractCommand.class})
@Properties(value={@Property(name="osgi.command.scope", value={"fabric"}), @Property(name="osgi.command.function", value={"ensemble-security"})})
public class EnsembleSecurity
extends AbstractCommandComponent {
    public static final String SCOPE_VALUE = "fabric";
    public static final String FUNCTION_VALUE = "ensemble-security";
    public static final String DESCRIPTION = "Display or update ensemble security configuration";
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=ProfileService.class)
    private final ValidatingReference<ProfileService> profileService = new ValidatingReference();
    @Reference(referenceInterface=ZooKeeperClusterService.class)
    private final ValidatingReference<ZooKeeperClusterService> clusterService = new ValidatingReference();

    public static EnsembleSASL isSASLEnabled(Map<String, String> configuration) {
        EnsembleSASL result = EnsembleSASL.NO_QUORUM;
        if (configuration != null) {
            String enabledInConfiguaration = configuration.get("quorum.auth.enableSasl");
            if ("true".equalsIgnoreCase(enabledInConfiguaration)) {
                result = EnsembleSASL.ENABLED;
            } else if ("false".equalsIgnoreCase(enabledInConfiguaration)) {
                result = EnsembleSASL.DISABLED;
            } else if (configuration.containsKey("server.1")) {
                result = EnsembleSASL.DISABLED;
            }
        }
        return result;
    }

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public Action createNewAction() {
        this.assertValid();
        return new EnsembleSecurityAction((FabricService)this.fabricService.get(), (ZooKeeperClusterService)this.clusterService.get(), (ProfileService)this.profileService.get());
    }

    void bindClusterService(ZooKeeperClusterService clusterService) {
        this.clusterService.bind((Object)clusterService);
    }

    void unbindClusterService(ZooKeeperClusterService clusterService) {
        this.clusterService.unbind((Object)clusterService);
    }

    void bindProfileService(ProfileService profileService) {
        this.profileService.bind((Object)profileService);
    }

    void unbindProfileService(ProfileService profileService) {
        this.profileService.unbind((Object)profileService);
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    public static enum EnsembleSASL {
        ENABLED,
        DISABLED,
        NO_QUORUM;

    }
}

