/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileRegistry;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Version;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="version-edit", scope="fabric", description="Edit version description")
public class VersionEditAction
extends AbstractAction {
    @Option(name="--description", description="The description notes of this version.")
    private String description;
    @Argument(index=0, description="The version to modify.", required=true)
    private String versionId;
    private final FabricService fabricService;

    VersionEditAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected Object doExecute() throws Exception {
        ProfileService profileService = (ProfileService)this.fabricService.adapt(ProfileService.class);
        ProfileRegistry profileRegistry = (ProfileRegistry)this.fabricService.adapt(ProfileRegistry.class);
        Version version = profileService.getVersion(this.versionId);
        if (version == null) {
            System.err.println("Version " + this.versionId + " does not exist.");
            return null;
        }
        profileRegistry.modifyVersionDescription(version, this.description);
        return null;
    }
}

