/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import io.fabric8.common.util.ChecksumUtils;
import io.fabric8.common.util.Closeables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.BundleContext;

public class DataStoreUtils {
    public static byte[] toBytes(Properties source) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            source.store(baos, null);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot store properties", ex);
        }
        return baos.toByteArray();
    }

    public static byte[] toBytes(Map<String, String> source) {
        return DataStoreUtils.toBytes(DataStoreUtils.toProperties(source));
    }

    public static Properties toProperties(byte[] source) {
        Properties rc = new Properties();
        if (source != null) {
            try {
                rc.load(new ByteArrayInputStream(source));
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot load properties", ex);
            }
        }
        return rc;
    }

    public static Map<String, String> toMap(Properties source) {
        HashMap<String, String> rc = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            rc.put((String)entry.getKey(), (String)entry.getValue());
        }
        return Collections.unmodifiableMap(rc);
    }

    public static Map<String, String> toMap(byte[] source) {
        return DataStoreUtils.toMap(DataStoreUtils.toProperties(source));
    }

    public static Properties toProperties(Map<String, String> source) {
        Properties rc = new Properties();
        for (Map.Entry<String, String> entry : source.entrySet()) {
            rc.put(entry.getKey(), entry.getValue());
        }
        return rc;
    }

    public static Properties toStringProperties(Map<String, ?> source) {
        Properties rc = new Properties();
        for (Map.Entry<String, ?> entry : source.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            rc.put(entry.getKey(), value.toString());
        }
        return rc;
    }

    public static String stripSuffix(String value, String suffix) {
        if (value.endsWith(suffix)) {
            return value.substring(0, value.length() - suffix.length());
        }
        return value;
    }

    public static String toString(Properties source) {
        StringWriter writer = new StringWriter();
        try {
            source.store(writer, null);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot store properties", ex);
        }
        return writer.toString();
    }

    public static Properties toProperties(String source) {
        Properties rc = new Properties();
        try {
            rc.load(new StringReader(source));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot load properties from: " + source, ex);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String substituteChecksum(String key) {
        InputStream is = null;
        try {
            URL url = new URL(key.substring("checksum:".length()));
            is = url.openStream();
            String string = String.valueOf(ChecksumUtils.checksum((InputStream)is));
            Closeables.closeQuietly((Closeable)is);
            return string;
        }
        catch (Exception ex) {
            String string = "0";
            return string;
        }
        finally {
            Closeables.closeQuietly(is);
        }
    }

    public static String substituteProfileProperty(String key, Map<String, Map<String, String>> configs) {
        String pid = key.substring("profile:".length(), key.indexOf("/"));
        String propertyKey = key.substring(key.indexOf("/") + 1);
        Map<String, String> targetProps = configs.get(pid);
        if (targetProps != null && targetProps.containsKey(propertyKey)) {
            return targetProps.get(propertyKey);
        }
        return key;
    }

    public static String substituteBundleProperty(String key, BundleContext bundleContext) {
        String value = null;
        if (bundleContext != null) {
            value = bundleContext.getProperty(key);
        }
        if (value == null) {
            value = System.getProperty(key);
        }
        return value != null ? value : "";
    }
}

