/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="container-resolver-set", scope="fabric", description="Apply the specified resolver policy to the specified container or containers", detailedDescription="classpath:containerResolverSet.txt")
public class ContainerResolverSetAction
extends AbstractAction {
    @Option(name="--all", description="Apply the resolver policy to all containers in the fabric.")
    private boolean all;
    @Option(name="--container", required=false, multiValued=true, description="Apply the resolver policy to the specified container. To specify multiple containers, use this flag multiple times.")
    private List<String> containerIds;
    @Option(name="-m", required=false, aliases={"--manual-ip"}, description="An address to use, when using the manualip resolver.")
    String manualIp;
    @Argument(index=0, required=true, multiValued=false, name="resolver", description="The resolver policy to set on the specified container(s). Possible values are: localip, localhostname, publicip, publichostname, manualip.")
    private String resolver;
    private final FabricService fabricService;
    private final CuratorFramework curator;

    ContainerResolverSetAction(FabricService fabricService, CuratorFramework curator) {
        this.fabricService = fabricService;
        this.curator = curator;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    protected Object doExecute() throws Exception {
        if (this.containerIds == null || this.containerIds.isEmpty()) {
            if (this.all) {
                this.containerIds = new ArrayList<String>();
                for (Container container : this.fabricService.getContainers()) {
                    this.containerIds.add(container.getId());
                }
            } else {
                System.out.println("No container has been specified. Assuming the current container.");
                this.containerIds = Arrays.asList(this.fabricService.getCurrentContainer().getId());
            }
        } else if (this.all) {
            throw new IllegalArgumentException("Can not use --all with a list of containers simultaneously.");
        }
        for (String containerId : this.containerIds) {
            Container container = this.fabricService.getContainer(containerId);
            container.setResolver(this.resolver);
            if (!this.resolver.equalsIgnoreCase("manualip") || this.manualIp == null || this.manualIp.isEmpty()) continue;
            ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)ZkPath.CONTAINER_MANUAL_IP.getPath(new String[]{containerId}), (String)this.manualIp);
        }
        return null;
    }
}

