/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.DataStore;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.api.ProfileService;
import io.fabric8.api.ZooKeeperClusterService;
import io.fabric8.commands.EnsembleSecurity;
import io.fabric8.utils.shell.ShellUtils;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="ensemble-security", scope="fabric", description="Display or update ensemble security configuration")
public class EnsembleSecurityAction
extends AbstractAction {
    public static Logger LOG = LoggerFactory.getLogger(EnsembleSecurityAction.class);
    private final ZooKeeperClusterService zooKeeperClusterService;
    private final ProfileService profileService;
    private final FabricService fabricService;
    @Option(name="--enable-sasl", multiValued=false, required=false, description="Enables SASL/DIGEST-MD5 mutual peer authentication.")
    protected Boolean enable = null;
    @Option(name="--disable-sasl", multiValued=false, required=false, description="Disables SASL/DIGEST-MD5 mutual peer authentication.")
    protected Boolean disable = null;

    public EnsembleSecurityAction(FabricService fabricService, ZooKeeperClusterService zooKeeperClusterService, ProfileService profileService) {
        this.fabricService = fabricService;
        this.zooKeeperClusterService = zooKeeperClusterService;
        this.profileService = profileService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        if (this.enable != null && this.disable != null) {
            System.out.println("Please specify whether to disable or enable SASL/DIGEST-MD5 mutual peer authentication");
            return null;
        }
        Map configuration = this.zooKeeperClusterService.getEnsembleConfiguration();
        EnsembleSecurity.EnsembleSASL saslStatus = EnsembleSecurity.isSASLEnabled(configuration);
        if (this.enable == null && this.disable == null) {
            if (saslStatus == EnsembleSecurity.EnsembleSASL.NO_QUORUM) {
                System.out.println("Zookeeper works in single server mode");
            } else {
                System.out.println("SASL/DIGEST-MD5 mutual peer authentication is currently " + (saslStatus == EnsembleSecurity.EnsembleSASL.ENABLED ? "enabled" : "disabled"));
            }
            return null;
        }
        if (saslStatus == EnsembleSecurity.EnsembleSASL.NO_QUORUM) {
            System.out.println("Can't configure SASL/DIGEST-MD5 mutual peer authentication - Zookeeper works in single server mode");
            return null;
        }
        if (Boolean.TRUE.equals(this.enable) && saslStatus == EnsembleSecurity.EnsembleSASL.ENABLED) {
            System.out.println("SASL/DIGEST-MD5 mutual peer authentication is already enabled");
            return null;
        }
        if (Boolean.TRUE.equals(this.disable) && saslStatus == EnsembleSecurity.EnsembleSASL.DISABLED) {
            System.out.println("SASL/DIGEST-MD5 mutual peer authentication is already disabled");
            return null;
        }
        boolean enabled = Boolean.TRUE.equals(this.enable);
        String response = ShellUtils.readLine(this.session, "This will " + (enabled ? "enable" : "disable") + " mutual QuorumPeer authentication using SASL/DIGEST-MD5 mechanism.\n" + "It is recommended to backup data/git and data/zookeeper directories.\n" + "During the process, Zookeeper connection may be suspended and resumed several times.\n" + "Are you sure want to proceed? (yes/no): ", false);
        if (response == null || !response.toLowerCase().equals("yes") && !response.toLowerCase().equals("y")) {
            return null;
        }
        try {
            CuratorFramework curator = (CuratorFramework)this.fabricService.adapt(CuratorFramework.class);
            DataStore dataStore = (DataStore)this.fabricService.adapt(DataStore.class);
            String clusterId = ZooKeeperUtils.getStringData((CuratorFramework)curator, (String)ZkPath.CONFIG_ENSEMBLES.getPath(new String[0]));
            String versionId = dataStore.getDefaultVersion();
            String profileId = "fabric-ensemble-" + clusterId;
            Profile ensembleProfile = this.profileService.getRequiredProfile(versionId, profileId);
            ProfileBuilder builder = ProfileBuilder.Factory.createFrom((Profile)ensembleProfile);
            Map properties = builder.getConfiguration("io.fabric8.zookeeper.server-" + clusterId);
            properties.put("quorum.auth.enableSasl", Boolean.toString(enabled));
            builder.addConfiguration("io.fabric8.zookeeper.server-" + clusterId, properties);
            final AtomicBoolean change = new AtomicBoolean(false);
            ConnectionStateListener csl = new ConnectionStateListener(){

                public void stateChanged(CuratorFramework curatorFramework, ConnectionState connectionState) {
                    System.out.println("Zookeeper connection state changed to: " + connectionState.name());
                    change.set(true);
                }
            };
            curator.getConnectionStateListenable().addListener((Object)csl);
            try {
                LOG.info((enabled ? "Enabling" : "Disabling") + " SASL/DIGEST-MD5 mutual peer authentication");
                this.profileService.updateProfile(builder.getProfile());
                Thread.sleep(5000L);
                for (int count = 12; count > 0; --count) {
                    try {
                        if (change.compareAndSet(false, false)) break;
                        change.set(false);
                        LOG.info("Monitoring Zookeeper connection state change");
                        Thread.sleep(5000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                System.out.println("Ensemble security configuration changed.");
            }
            finally {
                curator.getConnectionStateListenable().removeListener((Object)csl);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            System.err.println("Problem during ensemble security configuration (please check log for details): " + e.getMessage());
        }
        return null;
    }
}

