/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Version;
import io.fabric8.commands.ProfileListAction;
import io.fabric8.commands.support.CommandUtils;
import io.fabric8.utils.TablePrinter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="version-list", scope="fabric", description="List the existing versions")
public class VersionListAction
extends AbstractAction {
    private final ProfileService profileService;
    private final FabricService fabricService;
    private static final Pattern ALLOWED_PROFILE_NAMES_PATTERN = Pattern.compile("^[a-zA-Z0-9]+[\\.a-zA-Z0-9_-]*$");

    VersionListAction(FabricService fabricService) {
        this.profileService = (ProfileService)fabricService.adapt(ProfileService.class);
        this.fabricService = fabricService;
    }

    protected Object doExecute() throws Exception {
        Container[] containers = this.fabricService.getContainers();
        List versions = this.profileService.getVersions();
        this.printVersions(containers, versions, this.fabricService.getDefaultVersionId(), System.out);
        return null;
    }

    protected void printVersions(Container[] containers, List<String> versions, String defaultVersionId, PrintStream out) {
        TablePrinter table = new TablePrinter();
        table.columns("version", "default", "# containers", "description");
        ArrayList<String> invalidVersion = new ArrayList<String>();
        for (String versionId : versions) {
            if (versionId != null && !versionId.isEmpty() && ALLOWED_PROFILE_NAMES_PATTERN.matcher(versionId).matches()) {
                boolean isDefault = versionId.equals(defaultVersionId);
                Version version = this.profileService.getRequiredVersion(versionId);
                int active = CommandUtils.countContainersByVersion(containers, version);
                String description = (String)version.getAttributes().get("description");
                table.row(version.getId(), isDefault ? "true" : "", ProfileListAction.activeContainerCountText(active), description);
                continue;
            }
            invalidVersion.add(versionId);
        }
        table.print();
        if (!invalidVersion.isEmpty()) {
            System.out.println("The following profile versions have been skipped since their names are not correct: " + ((Object)invalidVersion).toString());
        }
    }
}

