/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricService;
import io.fabric8.commands.support.ContainerGlobSupport;
import io.fabric8.utils.shell.ShellUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

public abstract class AbstractContainerLifecycleAction
extends AbstractAction {
    @Option(name="--user", description="The username to use.")
    protected String user;
    @Option(name="--password", description="The password to use.")
    protected String password;
    @Option(name="--prompt", description="Prompt the password to use. This will also hide it.")
    protected boolean prompt = false;
    @Option(name="-f", aliases={"--force"}, multiValued=false, required=false, description="Force the execution of the command regardless of the known state of the container")
    protected boolean force = false;
    @Argument(index=0, name="container", description="The container names", required=true, multiValued=true)
    protected List<String> containers = null;
    protected final FabricService fabricService;
    protected final DataStore dataStore;

    protected AbstractContainerLifecycleAction(FabricService fabricService) {
        this.fabricService = fabricService;
        this.dataStore = (DataStore)fabricService.adapt(DataStore.class);
    }

    protected void applyUpdatedCredentials(Container container) throws IOException {
        CreateContainerMetadata metadata;
        if (this.user != null && this.password == null && this.prompt) {
            this.password = ShellUtils.readLine(this.session, "Password for " + this.user + "@" + container + ": ", true);
        }
        if ((this.user != null || this.password != null) && (metadata = container.getMetadata()) != null) {
            metadata.updateCredentials(this.user, this.password);
            this.dataStore.setContainerMetadata(container.getMetadata());
        }
    }

    protected Collection<String> expandGlobNames(List<String> containerNames) {
        return ContainerGlobSupport.expandGlobNames(this.fabricService, containerNames);
    }
}

