/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.ZooKeeperClusterService;
import io.fabric8.commands.EnsembleSecurity;
import java.io.StringWriter;
import java.util.Map;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="ensemble-summary", scope="fabric", description="Display ensemble information")
public class EnsembleSummaryAction
extends AbstractAction {
    private final ZooKeeperClusterService zooKeeperClusterService;

    public EnsembleSummaryAction(ZooKeeperClusterService zooKeeperClusterService) {
        this.zooKeeperClusterService = zooKeeperClusterService;
    }

    protected Object doExecute() throws Exception {
        StringWriter containers = new StringWriter();
        if (this.zooKeeperClusterService.getEnsembleContainers() != null) {
            for (String container : this.zooKeeperClusterService.getEnsembleContainers()) {
                containers.append(", ").append(container);
            }
        }
        System.out.println("Ensemble URL: " + this.zooKeeperClusterService.getZooKeeperUrl());
        System.out.println("Ensemble containers: " + (containers.toString().length() > 2 ? containers.toString().substring(2) : "Can't find container names"));
        Map configuration = this.zooKeeperClusterService.getEnsembleConfiguration();
        switch (EnsembleSecurity.isSASLEnabled(configuration)) {
            case ENABLED: {
                System.out.println("SASL/DIGEST-MD5 mutual peer authentication is enabled");
                break;
            }
            case DISABLED: {
                System.out.println("SASL/DIGEST-MD5 mutual peer authentication is disabled");
                break;
            }
            case NO_QUORUM: {
                System.out.println("SASL/DIGEST-MD5 mutual peer authentication is disabled - Zookeeper works in single server mode");
            }
        }
        return null;
    }
}

