/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.zookeeper.ZkPath;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.karaf.shell.console.AbstractAction;

public abstract class JMXCommandActionSupport
extends AbstractAction {
    protected final FabricService fabricService;
    protected final CuratorFramework curator;
    protected final RuntimeProperties runtimeProperties;

    public JMXCommandActionSupport(FabricService fabricService, CuratorFramework curator, RuntimeProperties runtimeProperties) {
        this.fabricService = fabricService;
        this.curator = curator;
        this.runtimeProperties = runtimeProperties;
    }

    protected Object doExecute() throws Exception {
        return null;
    }

    protected void cleanResponses() {
        for (Container container : this.fabricService.getContainers()) {
            try {
                String path = ZkPath.COMMANDS_RESPONSES.getPath(new String[]{container.getId()});
                List responses = (List)this.curator.getChildren().forPath(path);
                for (String r : responses) {
                    this.curator.delete().forPath(path + "/" + r);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String map(Object jmxRequest) throws JsonProcessingException {
        ObjectMapper mapper = this.getObjectMapper();
        try {
            String string = mapper.writeValueAsString(jmxRequest);
            return string;
        }
        finally {
            mapper.getTypeFactory().clearCache();
        }
    }

    protected ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setTypeFactory(TypeFactory.defaultInstance().withClassLoader(((Object)((Object)this)).getClass().getClassLoader()));
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        return mapper;
    }
}

